/* This file was generated with JastAdd2 (http://jastadd.org) version 2.3.2 */
package org.extendj.neobeaver.ast;
import org.extendj.neobeaver.Parser.SourcePosition;
import org.extendj.neobeaver.Parser.Symbol;
/**
 * @ast node
 * @declaredat /home/jesper/git/neobeaver/core/src/grammar/Grammar.ast:6
 * @astdecl GProduction : GDecl ::= [Type] <Name:String> GRule*;
 * @production GProduction : {@link GDecl} ::= <span class="component">[{@link Type}]</span> <span class="component">&lt;Name:String&gt;</span> <span class="component">{@link GRule}*</span>;

 */
public class GProduction extends GDecl implements Cloneable {
  /**
   * @aspect Grammar
   * @declaredat /home/jesper/git/neobeaver/core/src/grammar/Grammar.jrag:29
   */
  public void accept(GVisitor vis) { vis.visit(this); }
  /**
   * @declaredat ASTNode:1
   */
  public GProduction() {
    super();
  }
  /**
   * Initializes the child array to the correct size.
   * Initializes List and Opt nta children.
   * @apilevel internal
   * @ast method
   * @declaredat ASTNode:10
   */
  public void init$Children() {
    children = new ASTNode[2];
    setChild(new Opt(), 0);
    setChild(new List(), 1);
  }
  /**
   * @declaredat ASTNode:15
   */
  @ASTNodeAnnotation.Constructor(
    name = {"Type", "Name", "GRule"},
    type = {"Opt<Type>", "String", "List<GRule>"},
    kind = {"Opt", "Token", "List"}
  )
  public GProduction(Opt<Type> p0, String p1, List<GRule> p2) {
    setChild(p0, 0);
    setName(p1);
    setChild(p2, 1);
  }
  /** @apilevel low-level 
   * @declaredat ASTNode:26
   */
  protected int numChildren() {
    return 2;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:30
   */
  public void flushAttrCache() {
    super.flushAttrCache();
  }
  /** @apilevel internal 
   * @declaredat ASTNode:34
   */
  public void flushCollectionCache() {
    super.flushCollectionCache();
  }
  /** @apilevel internal 
   * @declaredat ASTNode:38
   */
  public GProduction clone() throws CloneNotSupportedException {
    GProduction node = (GProduction) super.clone();
    return node;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:43
   */
  public GProduction copy() {
    try {
      GProduction node = (GProduction) clone();
      node.parent = null;
      if (children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @deprecated Please use treeCopy or treeCopyNoTransform instead
   * @declaredat ASTNode:62
   */
  @Deprecated
  public GProduction fullCopy() {
    return treeCopyNoTransform();
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @declaredat ASTNode:72
   */
  public GProduction treeCopyNoTransform() {
    GProduction tree = (GProduction) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if (child != null) {
          child = child.treeCopyNoTransform();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The subtree of this node is traversed to trigger rewrites before copy.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @declaredat ASTNode:92
   */
  public GProduction treeCopy() {
    GProduction tree = (GProduction) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) getChild(i);
        if (child != null) {
          child = child.treeCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:106
   */
  protected boolean is$Equal(ASTNode node) {
    return super.is$Equal(node) && (tokenString_Name == ((GProduction) node).tokenString_Name);    
  }
  /**
   * Replaces the optional node for the Type child. This is the <code>Opt</code>
   * node containing the child Type, not the actual child!
   * @param opt The new node to be used as the optional node for the Type child.
   * @apilevel low-level
   */
  public void setTypeOpt(Opt<Type> opt) {
    setChild(opt, 0);
  }
  /**
   * Replaces the (optional) Type child.
   * @param node The new node to be used as the Type child.
   * @apilevel high-level
   */
  public void setType(Type node) {
    getTypeOpt().setChild(node, 0);
  }
  /**
   * Check whether the optional Type child exists.
   * @return {@code true} if the optional Type child exists, {@code false} if it does not.
   * @apilevel high-level
   */
  public boolean hasType() {
    return getTypeOpt().getNumChild() != 0;
  }
  /**
   * Retrieves the (optional) Type child.
   * @return The Type child, if it exists. Returns {@code null} otherwise.
   * @apilevel low-level
   */
  public Type getType() {
    return (Type) getTypeOpt().getChild(0);
  }
  /**
   * Retrieves the optional node for the Type child. This is the <code>Opt</code> node containing the child Type, not the actual child!
   * @return The optional node for child the Type child.
   * @apilevel low-level
   */
  @ASTNodeAnnotation.OptChild(name="Type")
  public Opt<Type> getTypeOpt() {
    return (Opt<Type>) getChild(0);
  }
  /**
   * Retrieves the optional node for child Type. This is the <code>Opt</code> node containing the child Type, not the actual child!
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The optional node for child Type.
   * @apilevel low-level
   */
  public Opt<Type> getTypeOptNoTransform() {
    return (Opt<Type>) getChildNoTransform(0);
  }
  /**
   * Replaces the lexeme Name.
   * @param value The new value for the lexeme Name.
   * @apilevel high-level
   */
  public void setName(String value) {
    tokenString_Name = value;
  }
  /** @apilevel internal 
   */
  protected String tokenString_Name;
  /**
   * Retrieves the value for the lexeme Name.
   * @return The value for the lexeme Name.
   * @apilevel high-level
   */
  @ASTNodeAnnotation.Token(name="Name")
  public String getName() {
    return tokenString_Name != null ? tokenString_Name : "";
  }
  /**
   * Replaces the GRule list.
   * @param list The new list node to be used as the GRule list.
   * @apilevel high-level
   */
  public void setGRuleList(List<GRule> list) {
    setChild(list, 1);
  }
  /**
   * Retrieves the number of children in the GRule list.
   * @return Number of children in the GRule list.
   * @apilevel high-level
   */
  public int getNumGRule() {
    return getGRuleList().getNumChild();
  }
  /**
   * Retrieves the number of children in the GRule list.
   * Calling this method will not trigger rewrites.
   * @return Number of children in the GRule list.
   * @apilevel low-level
   */
  public int getNumGRuleNoTransform() {
    return getGRuleListNoTransform().getNumChildNoTransform();
  }
  /**
   * Retrieves the element at index {@code i} in the GRule list.
   * @param i Index of the element to return.
   * @return The element at position {@code i} in the GRule list.
   * @apilevel high-level
   */
  public GRule getGRule(int i) {
    return (GRule) getGRuleList().getChild(i);
  }
  /**
   * Check whether the GRule list has any children.
   * @return {@code true} if it has at least one child, {@code false} otherwise.
   * @apilevel high-level
   */
  public boolean hasGRule() {
    return getGRuleList().getNumChild() != 0;
  }
  /**
   * Append an element to the GRule list.
   * @param node The element to append to the GRule list.
   * @apilevel high-level
   */
  public void addGRule(GRule node) {
    List<GRule> list = (parent == null) ? getGRuleListNoTransform() : getGRuleList();
    list.addChild(node);
  }
  /** @apilevel low-level 
   */
  public void addGRuleNoTransform(GRule node) {
    List<GRule> list = getGRuleListNoTransform();
    list.addChild(node);
  }
  /**
   * Replaces the GRule list element at index {@code i} with the new node {@code node}.
   * @param node The new node to replace the old list element.
   * @param i The list index of the node to be replaced.
   * @apilevel high-level
   */
  public void setGRule(GRule node, int i) {
    List<GRule> list = getGRuleList();
    list.setChild(node, i);
  }
  /**
   * Retrieves the GRule list.
   * @return The node representing the GRule list.
   * @apilevel high-level
   */
  @ASTNodeAnnotation.ListChild(name="GRule")
  public List<GRule> getGRuleList() {
    List<GRule> list = (List<GRule>) getChild(1);
    return list;
  }
  /**
   * Retrieves the GRule list.
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The node representing the GRule list.
   * @apilevel low-level
   */
  public List<GRule> getGRuleListNoTransform() {
    return (List<GRule>) getChildNoTransform(1);
  }
  /**
   * @return the element at index {@code i} in the GRule list without
   * triggering rewrites.
   */
  public GRule getGRuleNoTransform(int i) {
    return (GRule) getGRuleListNoTransform().getChildNoTransform(i);
  }
  /**
   * Retrieves the GRule list.
   * @return The node representing the GRule list.
   * @apilevel high-level
   */
  public List<GRule> getGRules() {
    return getGRuleList();
  }
  /**
   * Retrieves the GRule list.
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The node representing the GRule list.
   * @apilevel low-level
   */
  public List<GRule> getGRulesNoTransform() {
    return getGRuleListNoTransform();
  }
}
