/* This file was generated with JastAdd2 (http://jastadd.org) version 2.3.2 */
package org.extendj.neobeaver.ast;
import org.extendj.neobeaver.Parser.SourcePosition;
import org.extendj.neobeaver.Parser.Symbol;
/**
 * @ast node
 * @declaredat /home/jesper/git/neobeaver/core/src/grammar/Grammar.ast:23
 * @astdecl GRule : ASTNode ::= GComponent* [Precedence:GPrecedence] [Action:GAction];
 * @production GRule : {@link ASTNode} ::= <span class="component">{@link GComponent}*</span> <span class="component">[Precedence:{@link GPrecedence}]</span> <span class="component">[Action:{@link GAction}]</span>;

 */
public class GRule extends ASTNode<ASTNode> implements Cloneable {
  /**
   * @aspect Grammar
   * @declaredat /home/jesper/git/neobeaver/core/src/grammar/Grammar.jrag:30
   */
  public void accept(GVisitor vis) { vis.visit(this); }
  /**
   * @declaredat ASTNode:1
   */
  public GRule() {
    super();
  }
  /**
   * Initializes the child array to the correct size.
   * Initializes List and Opt nta children.
   * @apilevel internal
   * @ast method
   * @declaredat ASTNode:10
   */
  public void init$Children() {
    children = new ASTNode[3];
    setChild(new List(), 0);
    setChild(new Opt(), 1);
    setChild(new Opt(), 2);
  }
  /**
   * @declaredat ASTNode:16
   */
  @ASTNodeAnnotation.Constructor(
    name = {"GComponent", "Precedence", "Action"},
    type = {"List<GComponent>", "Opt<GPrecedence>", "Opt<GAction>"},
    kind = {"List", "Opt", "Opt"}
  )
  public GRule(List<GComponent> p0, Opt<GPrecedence> p1, Opt<GAction> p2) {
    setChild(p0, 0);
    setChild(p1, 1);
    setChild(p2, 2);
  }
  /** @apilevel low-level 
   * @declaredat ASTNode:27
   */
  protected int numChildren() {
    return 3;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:31
   */
  public void flushAttrCache() {
    super.flushAttrCache();
  }
  /** @apilevel internal 
   * @declaredat ASTNode:35
   */
  public void flushCollectionCache() {
    super.flushCollectionCache();
  }
  /** @apilevel internal 
   * @declaredat ASTNode:39
   */
  public GRule clone() throws CloneNotSupportedException {
    GRule node = (GRule) super.clone();
    return node;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:44
   */
  public GRule copy() {
    try {
      GRule node = (GRule) clone();
      node.parent = null;
      if (children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @deprecated Please use treeCopy or treeCopyNoTransform instead
   * @declaredat ASTNode:63
   */
  @Deprecated
  public GRule fullCopy() {
    return treeCopyNoTransform();
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @declaredat ASTNode:73
   */
  public GRule treeCopyNoTransform() {
    GRule tree = (GRule) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if (child != null) {
          child = child.treeCopyNoTransform();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The subtree of this node is traversed to trigger rewrites before copy.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @declaredat ASTNode:93
   */
  public GRule treeCopy() {
    GRule tree = (GRule) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) getChild(i);
        if (child != null) {
          child = child.treeCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:107
   */
  protected boolean is$Equal(ASTNode node) {
    return super.is$Equal(node);    
  }
  /**
   * Replaces the GComponent list.
   * @param list The new list node to be used as the GComponent list.
   * @apilevel high-level
   */
  public void setGComponentList(List<GComponent> list) {
    setChild(list, 0);
  }
  /**
   * Retrieves the number of children in the GComponent list.
   * @return Number of children in the GComponent list.
   * @apilevel high-level
   */
  public int getNumGComponent() {
    return getGComponentList().getNumChild();
  }
  /**
   * Retrieves the number of children in the GComponent list.
   * Calling this method will not trigger rewrites.
   * @return Number of children in the GComponent list.
   * @apilevel low-level
   */
  public int getNumGComponentNoTransform() {
    return getGComponentListNoTransform().getNumChildNoTransform();
  }
  /**
   * Retrieves the element at index {@code i} in the GComponent list.
   * @param i Index of the element to return.
   * @return The element at position {@code i} in the GComponent list.
   * @apilevel high-level
   */
  public GComponent getGComponent(int i) {
    return (GComponent) getGComponentList().getChild(i);
  }
  /**
   * Check whether the GComponent list has any children.
   * @return {@code true} if it has at least one child, {@code false} otherwise.
   * @apilevel high-level
   */
  public boolean hasGComponent() {
    return getGComponentList().getNumChild() != 0;
  }
  /**
   * Append an element to the GComponent list.
   * @param node The element to append to the GComponent list.
   * @apilevel high-level
   */
  public void addGComponent(GComponent node) {
    List<GComponent> list = (parent == null) ? getGComponentListNoTransform() : getGComponentList();
    list.addChild(node);
  }
  /** @apilevel low-level 
   */
  public void addGComponentNoTransform(GComponent node) {
    List<GComponent> list = getGComponentListNoTransform();
    list.addChild(node);
  }
  /**
   * Replaces the GComponent list element at index {@code i} with the new node {@code node}.
   * @param node The new node to replace the old list element.
   * @param i The list index of the node to be replaced.
   * @apilevel high-level
   */
  public void setGComponent(GComponent node, int i) {
    List<GComponent> list = getGComponentList();
    list.setChild(node, i);
  }
  /**
   * Retrieves the GComponent list.
   * @return The node representing the GComponent list.
   * @apilevel high-level
   */
  @ASTNodeAnnotation.ListChild(name="GComponent")
  public List<GComponent> getGComponentList() {
    List<GComponent> list = (List<GComponent>) getChild(0);
    return list;
  }
  /**
   * Retrieves the GComponent list.
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The node representing the GComponent list.
   * @apilevel low-level
   */
  public List<GComponent> getGComponentListNoTransform() {
    return (List<GComponent>) getChildNoTransform(0);
  }
  /**
   * @return the element at index {@code i} in the GComponent list without
   * triggering rewrites.
   */
  public GComponent getGComponentNoTransform(int i) {
    return (GComponent) getGComponentListNoTransform().getChildNoTransform(i);
  }
  /**
   * Retrieves the GComponent list.
   * @return The node representing the GComponent list.
   * @apilevel high-level
   */
  public List<GComponent> getGComponents() {
    return getGComponentList();
  }
  /**
   * Retrieves the GComponent list.
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The node representing the GComponent list.
   * @apilevel low-level
   */
  public List<GComponent> getGComponentsNoTransform() {
    return getGComponentListNoTransform();
  }
  /**
   * Replaces the optional node for the Precedence child. This is the <code>Opt</code>
   * node containing the child Precedence, not the actual child!
   * @param opt The new node to be used as the optional node for the Precedence child.
   * @apilevel low-level
   */
  public void setPrecedenceOpt(Opt<GPrecedence> opt) {
    setChild(opt, 1);
  }
  /**
   * Replaces the (optional) Precedence child.
   * @param node The new node to be used as the Precedence child.
   * @apilevel high-level
   */
  public void setPrecedence(GPrecedence node) {
    getPrecedenceOpt().setChild(node, 0);
  }
  /**
   * Check whether the optional Precedence child exists.
   * @return {@code true} if the optional Precedence child exists, {@code false} if it does not.
   * @apilevel high-level
   */
  public boolean hasPrecedence() {
    return getPrecedenceOpt().getNumChild() != 0;
  }
  /**
   * Retrieves the (optional) Precedence child.
   * @return The Precedence child, if it exists. Returns {@code null} otherwise.
   * @apilevel low-level
   */
  public GPrecedence getPrecedence() {
    return (GPrecedence) getPrecedenceOpt().getChild(0);
  }
  /**
   * Retrieves the optional node for the Precedence child. This is the <code>Opt</code> node containing the child Precedence, not the actual child!
   * @return The optional node for child the Precedence child.
   * @apilevel low-level
   */
  @ASTNodeAnnotation.OptChild(name="Precedence")
  public Opt<GPrecedence> getPrecedenceOpt() {
    return (Opt<GPrecedence>) getChild(1);
  }
  /**
   * Retrieves the optional node for child Precedence. This is the <code>Opt</code> node containing the child Precedence, not the actual child!
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The optional node for child Precedence.
   * @apilevel low-level
   */
  public Opt<GPrecedence> getPrecedenceOptNoTransform() {
    return (Opt<GPrecedence>) getChildNoTransform(1);
  }
  /**
   * Replaces the optional node for the Action child. This is the <code>Opt</code>
   * node containing the child Action, not the actual child!
   * @param opt The new node to be used as the optional node for the Action child.
   * @apilevel low-level
   */
  public void setActionOpt(Opt<GAction> opt) {
    setChild(opt, 2);
  }
  /**
   * Replaces the (optional) Action child.
   * @param node The new node to be used as the Action child.
   * @apilevel high-level
   */
  public void setAction(GAction node) {
    getActionOpt().setChild(node, 0);
  }
  /**
   * Check whether the optional Action child exists.
   * @return {@code true} if the optional Action child exists, {@code false} if it does not.
   * @apilevel high-level
   */
  public boolean hasAction() {
    return getActionOpt().getNumChild() != 0;
  }
  /**
   * Retrieves the (optional) Action child.
   * @return The Action child, if it exists. Returns {@code null} otherwise.
   * @apilevel low-level
   */
  public GAction getAction() {
    return (GAction) getActionOpt().getChild(0);
  }
  /**
   * Retrieves the optional node for the Action child. This is the <code>Opt</code> node containing the child Action, not the actual child!
   * @return The optional node for child the Action child.
   * @apilevel low-level
   */
  @ASTNodeAnnotation.OptChild(name="Action")
  public Opt<GAction> getActionOpt() {
    return (Opt<GAction>) getChild(2);
  }
  /**
   * Retrieves the optional node for child Action. This is the <code>Opt</code> node containing the child Action, not the actual child!
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The optional node for child Action.
   * @apilevel low-level
   */
  public Opt<GAction> getActionOptNoTransform() {
    return (Opt<GAction>) getChildNoTransform(2);
  }
}
