/* This file was generated with JastAdd2 (http://jastadd.org) version 2.3.2 */
package org.extendj.neobeaver.ast;
import org.extendj.neobeaver.Parser.SourcePosition;
import org.extendj.neobeaver.Parser.Symbol;
/**
 * @ast node
 * @declaredat /home/jesper/git/neobeaver/core/src/grammar/Grammar.ast:19
 * @astdecl LeftAssoc : GDecl ::= Sym:GSym*;
 * @production LeftAssoc : {@link GDecl} ::= <span class="component">Sym:{@link GSym}*</span>;

 */
public class LeftAssoc extends GDecl implements Cloneable {
  /**
   * @aspect Grammar
   * @declaredat /home/jesper/git/neobeaver/core/src/grammar/Grammar.jrag:40
   */
  public void accept(GVisitor vis) { vis.visit(this); }
  /**
   * @declaredat ASTNode:1
   */
  public LeftAssoc() {
    super();
  }
  /**
   * Initializes the child array to the correct size.
   * Initializes List and Opt nta children.
   * @apilevel internal
   * @ast method
   * @declaredat ASTNode:10
   */
  public void init$Children() {
    children = new ASTNode[1];
    setChild(new List(), 0);
  }
  /**
   * @declaredat ASTNode:14
   */
  @ASTNodeAnnotation.Constructor(
    name = {"Sym"},
    type = {"List<GSym>"},
    kind = {"List"}
  )
  public LeftAssoc(List<GSym> p0) {
    setChild(p0, 0);
  }
  /** @apilevel low-level 
   * @declaredat ASTNode:23
   */
  protected int numChildren() {
    return 1;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:27
   */
  public void flushAttrCache() {
    super.flushAttrCache();
  }
  /** @apilevel internal 
   * @declaredat ASTNode:31
   */
  public void flushCollectionCache() {
    super.flushCollectionCache();
  }
  /** @apilevel internal 
   * @declaredat ASTNode:35
   */
  public LeftAssoc clone() throws CloneNotSupportedException {
    LeftAssoc node = (LeftAssoc) super.clone();
    return node;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:40
   */
  public LeftAssoc copy() {
    try {
      LeftAssoc node = (LeftAssoc) clone();
      node.parent = null;
      if (children != null) {
        node.children = (ASTNode[]) children.clone();
      }
      return node;
    } catch (CloneNotSupportedException e) {
      throw new Error("Error: clone not supported for " + getClass().getName());
    }
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @deprecated Please use treeCopy or treeCopyNoTransform instead
   * @declaredat ASTNode:59
   */
  @Deprecated
  public LeftAssoc fullCopy() {
    return treeCopyNoTransform();
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @declaredat ASTNode:69
   */
  public LeftAssoc treeCopyNoTransform() {
    LeftAssoc tree = (LeftAssoc) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) children[i];
        if (child != null) {
          child = child.treeCopyNoTransform();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }
  /**
   * Create a deep copy of the AST subtree at this node.
   * The subtree of this node is traversed to trigger rewrites before copy.
   * The copy is dangling, i.e. has no parent.
   * @return dangling copy of the subtree at this node
   * @apilevel low-level
   * @declaredat ASTNode:89
   */
  public LeftAssoc treeCopy() {
    LeftAssoc tree = (LeftAssoc) copy();
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        ASTNode child = (ASTNode) getChild(i);
        if (child != null) {
          child = child.treeCopy();
          tree.setChild(child, i);
        }
      }
    }
    return tree;
  }
  /** @apilevel internal 
   * @declaredat ASTNode:103
   */
  protected boolean is$Equal(ASTNode node) {
    return super.is$Equal(node);    
  }
  /**
   * Replaces the Sym list.
   * @param list The new list node to be used as the Sym list.
   * @apilevel high-level
   */
  public void setSymList(List<GSym> list) {
    setChild(list, 0);
  }
  /**
   * Retrieves the number of children in the Sym list.
   * @return Number of children in the Sym list.
   * @apilevel high-level
   */
  public int getNumSym() {
    return getSymList().getNumChild();
  }
  /**
   * Retrieves the number of children in the Sym list.
   * Calling this method will not trigger rewrites.
   * @return Number of children in the Sym list.
   * @apilevel low-level
   */
  public int getNumSymNoTransform() {
    return getSymListNoTransform().getNumChildNoTransform();
  }
  /**
   * Retrieves the element at index {@code i} in the Sym list.
   * @param i Index of the element to return.
   * @return The element at position {@code i} in the Sym list.
   * @apilevel high-level
   */
  public GSym getSym(int i) {
    return (GSym) getSymList().getChild(i);
  }
  /**
   * Check whether the Sym list has any children.
   * @return {@code true} if it has at least one child, {@code false} otherwise.
   * @apilevel high-level
   */
  public boolean hasSym() {
    return getSymList().getNumChild() != 0;
  }
  /**
   * Append an element to the Sym list.
   * @param node The element to append to the Sym list.
   * @apilevel high-level
   */
  public void addSym(GSym node) {
    List<GSym> list = (parent == null) ? getSymListNoTransform() : getSymList();
    list.addChild(node);
  }
  /** @apilevel low-level 
   */
  public void addSymNoTransform(GSym node) {
    List<GSym> list = getSymListNoTransform();
    list.addChild(node);
  }
  /**
   * Replaces the Sym list element at index {@code i} with the new node {@code node}.
   * @param node The new node to replace the old list element.
   * @param i The list index of the node to be replaced.
   * @apilevel high-level
   */
  public void setSym(GSym node, int i) {
    List<GSym> list = getSymList();
    list.setChild(node, i);
  }
  /**
   * Retrieves the Sym list.
   * @return The node representing the Sym list.
   * @apilevel high-level
   */
  @ASTNodeAnnotation.ListChild(name="Sym")
  public List<GSym> getSymList() {
    List<GSym> list = (List<GSym>) getChild(0);
    return list;
  }
  /**
   * Retrieves the Sym list.
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The node representing the Sym list.
   * @apilevel low-level
   */
  public List<GSym> getSymListNoTransform() {
    return (List<GSym>) getChildNoTransform(0);
  }
  /**
   * @return the element at index {@code i} in the Sym list without
   * triggering rewrites.
   */
  public GSym getSymNoTransform(int i) {
    return (GSym) getSymListNoTransform().getChildNoTransform(i);
  }
  /**
   * Retrieves the Sym list.
   * @return The node representing the Sym list.
   * @apilevel high-level
   */
  public List<GSym> getSyms() {
    return getSymList();
  }
  /**
   * Retrieves the Sym list.
   * <p><em>This method does not invoke AST transformations.</em></p>
   * @return The node representing the Sym list.
   * @apilevel low-level
   */
  public List<GSym> getSymsNoTransform() {
    return getSymListNoTransform();
  }
}
