/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.HashMap;
import java.util.Map;
import org.extendj.neobeaver.IdSymbol;
import org.extendj.neobeaver.NamedToken;
import org.extendj.neobeaver.Nonterminal;
import org.extendj.neobeaver.Symbol;

public class SymbolCache {
    private int nextId = 2;
    private final Map<String, Symbol> map = new HashMap<String, Symbol>();

    public Symbol nta(String name) {
        return this.get(new Nonterminal(name));
    }

    public Symbol list(Symbol sym) {
        return this.get(new Nonterminal("" + sym + "$list"));
    }

    public Symbol opt(Symbol sym) {
        return this.get(new Nonterminal("" + sym + "$opt"));
    }

    public Symbol terminal(String name) {
        return this.get(new NamedToken(name));
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public Symbol get(String name) {
        return this.map.get(name);
    }

    public Symbol get(Symbol symbol) {
        if (!this.contains(symbol.name())) {
            this.map.put(symbol.name(), new IdSymbol(this.nextId, symbol));
            ++this.nextId;
        }
        return this.get(symbol.name());
    }
}

