/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.List;
import org.extendj.neobeaver.ProblemHandler;

public class ProblemLogger
implements ProblemHandler {
    private boolean errored = false;
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();

    @Override
    public void error(String message) {
        this.errors.add(message);
        this.errored = true;
    }

    @Override
    public final void errorf(String fmt, Object ... args) {
        this.error(String.format(fmt, args));
    }

    @Override
    public void warn(String message) {
        this.warnings.add(message);
    }

    @Override
    public final void warnf(String fmt, Object ... args) {
        this.warn(String.format(fmt, args));
    }

    public void report() {
        for (String error : this.errors) {
            System.err.print("ERROR: ");
            System.err.println(error);
        }
        for (String warning : this.warnings) {
            System.err.print("WARNING: ");
            System.err.println(warning);
        }
        this.errors.clear();
        this.warnings.clear();
    }

    @Override
    public boolean errored() {
        return this.errored;
    }
}

