/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Action;
import org.extendj.neobeaver.ActionKind;
import org.extendj.neobeaver.Conflict;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.ProblemHandler;
import org.extendj.neobeaver.Reduce;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Shift;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple3;

public class TransitionTable {
    public final ItemSet goal;
    public final Map<ItemSet, Map<Symbol, ItemSet>> map;
    public final Map<ItemSet, Map<Symbol, Action>> actions;
    private final Map<ItemSet, Map<Symbol, List<Action>>> actionMap;
    public final List<Conflict> conflicts;

    public TransitionTable(ItemSet goal, Map<ItemSet, Map<Symbol, ItemSet>> map, Map<ItemSet, Map<Symbol, Action>> actions, Map<ItemSet, Map<Symbol, List<Action>>> actionMap, List<Conflict> conflicts) {
        this.goal = goal;
        this.map = map;
        this.actions = actions;
        this.actionMap = actionMap;
        this.conflicts = conflicts;
    }

    public static TransitionTable build(Grammar grammar, ProblemHandler problems, Set<Symbol> syms, List<ItemSet> itemSets, ItemSet goal, Map<ItemSet, ItemSet> coreMap, List<Tuple3<ItemSet, ItemSet, Symbol>> transitions, List<Tuple3<ItemSet, Symbol, Action>> extraActions) {
        HashMap<ItemSet, Map<Symbol, ItemSet>> map = new HashMap<ItemSet, Map<Symbol, ItemSet>>();
        HashMap<ItemSet, Map<Symbol, List<Action>>> actions = new HashMap<ItemSet, Map<Symbol, List<Action>>>();
        for (ItemSet itemSet : itemSets) {
            map.put(itemSet, new HashMap());
            actions.put(itemSet, new HashMap());
        }
        for (Tuple3 tuple3 : transitions) {
            Iterator<Object> source = coreMap.get(tuple3.first);
            ItemSet itemSet = coreMap.get(tuple3.second);
            Symbol sym = (Symbol)tuple3.third;
            ((Map)map.get(source)).put(sym, itemSet);
        }
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol : syms) {
            if (symbol.isTerminal()) {
                arrayList.add(symbol);
                continue;
            }
            nonterminals.add(symbol);
        }
        for (ItemSet itemSet : itemSets) {
            for (Item item : itemSet.allItems()) {
                if (item.dot < item.rule.rhs.size()) continue;
                Collection<Tuple3<ItemSet, Symbol, Action>> reduceActs = item.reduceActions(grammar, itemSet);
                for (Tuple3<ItemSet, Symbol, Action> action : reduceActs) {
                    TransitionTable.addAction(actions, (ItemSet)action.first, (Symbol)action.second, (Action)action.third);
                }
            }
            Map setTransitions = (Map)map.get(itemSet);
            for (Symbol sym : arrayList) {
                if (!setTransitions.containsKey(sym)) continue;
                TransitionTable.addAction(actions, itemSet, sym, new Shift(sym, (ItemSet)setTransitions.get(sym)));
            }
        }
        for (Tuple3 tuple3 : extraActions) {
            TransitionTable.addAction(actions, (ItemSet)tuple3.first, (Symbol)tuple3.second, (Action)tuple3.third);
        }
        LinkedList<Conflict> conflicts = new LinkedList<Conflict>();
        Map<ItemSet, Map<Symbol, Action>> map2 = TransitionTable.buildActionMap(grammar, problems, actions, conflicts);
        return new TransitionTable(goal, map, map2, actions, conflicts);
    }

    private static Map<ItemSet, Map<Symbol, Action>> buildActionMap(Grammar grammar, ProblemHandler problems, Map<ItemSet, Map<Symbol, List<Action>>> actionMap, List<Conflict> conflicts) {
        HashMap<ItemSet, Map<Symbol, Action>> actions = new HashMap<ItemSet, Map<Symbol, Action>>();
        for (Map.Entry<ItemSet, Map<Symbol, List<Action>>> entry : actionMap.entrySet()) {
            ItemSet itemSet = entry.getKey();
            Map<Symbol, List<Action>> inMap = entry.getValue();
            HashMap<Symbol, Action> outMap = new HashMap<Symbol, Action>();
            actions.put(itemSet, outMap);
            for (Map.Entry<Symbol, List<Action>> actionEntry : inMap.entrySet()) {
                Symbol sym = actionEntry.getKey();
                List<Action> setActions = actionEntry.getValue();
                if (setActions.size() > 1) {
                    Action otherAction;
                    int i;
                    Action action;
                    boolean change = true;
                    block2: while (change) {
                        change = false;
                        action = setActions.get(0);
                        for (i = 1; i < setActions.size(); ++i) {
                            otherAction = setActions.get(i);
                            Resolution selected = TransitionTable.resolve(problems, itemSet, action, otherAction, grammar, sym);
                            if (selected == Resolution.FIRST) {
                                setActions.remove(i);
                                change = true;
                                continue block2;
                            }
                            if (selected != Resolution.SECOND) continue;
                            setActions.remove(0);
                            change = true;
                            continue block2;
                        }
                    }
                    action = setActions.get(0);
                    for (i = 1; i < setActions.size(); ++i) {
                        otherAction = setActions.get(i);
                        conflicts.add(new Conflict(itemSet, sym, action, otherAction));
                    }
                }
                outMap.put(actionEntry.getKey(), setActions.get(0));
            }
        }
        return actions;
    }

    private static void addAction(Map<ItemSet, Map<Symbol, List<Action>>> actionMap, ItemSet set, Symbol sym, Action action) {
        Map<Symbol, List<Action>> setActions = actionMap.get(set);
        List<Action> actionSet = setActions.get(sym);
        if (actionSet == null) {
            actionSet = new LinkedList<Action>();
            setActions.put(sym, actionSet);
        }
        actionSet.add(action);
    }

    public void checkProblems(Grammar grammar, ProblemHandler problems, Set<Symbol> unused, boolean unreachableError) {
        HashSet<Rule> reduceRules = new HashSet<Rule>();
        for (Map.Entry<ItemSet, Map<Symbol, List<Action>>> entry : this.actionMap.entrySet()) {
            for (List<Action> actionList : entry.getValue().values()) {
                for (Action action : actionList) {
                    if (action.kind() != ActionKind.REDUCE) continue;
                    reduceRules.add(((Reduce)action).rule);
                }
            }
        }
        for (Rule rule : grammar.rules) {
            if (rule.lhs == Symbol.GOAL || unused.contains(rule.lhs) || reduceRules.contains(rule)) continue;
            String message = "rule can not be reduced: " + rule;
            if (unreachableError) {
                problems.error(message);
                continue;
            }
            problems.warn(message);
        }
    }

    public static Resolution resolve(ProblemHandler problems, ItemSet set, Action firstAction, Action secondAction, Grammar grammar, Symbol sym) {
        SelectedAction selected;
        String first = grammar.precedenceTerminal(firstAction);
        String second = grammar.precedenceTerminal(secondAction);
        if (grammar.precedence(first) < grammar.precedence(second)) {
            return Resolution.FIRST;
        }
        if (grammar.precedence(first) > grammar.precedence(second)) {
            return Resolution.SECOND;
        }
        if (grammar.nonassoc(first) || grammar.nonassoc(second)) {
            return Resolution.NONE;
        }
        if (grammar.left(first) && grammar.left(second)) {
            selected = SelectedAction.REDUCE;
        } else if (grammar.right(first) && grammar.right(second)) {
            selected = SelectedAction.SHIFT;
        } else if (firstAction.kind() == ActionKind.SHIFT && secondAction.kind() == ActionKind.REDUCE || firstAction.kind() == ActionKind.REDUCE && secondAction.kind() == ActionKind.SHIFT) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("resolved SHIFT/REDUCE conflict on [%s] by selecting SHIFT:%n  %s%n  %s", sym, firstAction, secondAction));
            sb.append(String.format("%nContext:", new Object[0]));
            for (Item it : set.relatedItems(sym)) {
                sb.append(String.format("%n  %s", it));
            }
            problems.warn(sb.toString());
            selected = SelectedAction.SHIFT;
        } else {
            selected = SelectedAction.NONE;
        }
        ActionKind kind = firstAction.kind();
        ActionKind otherKind = secondAction.kind();
        if (selected == SelectedAction.SHIFT) {
            if (kind == ActionKind.SHIFT && otherKind == ActionKind.REDUCE) {
                return Resolution.FIRST;
            }
            if (kind == ActionKind.REDUCE && otherKind == ActionKind.SHIFT) {
                return Resolution.SECOND;
            }
        }
        if (selected == SelectedAction.REDUCE) {
            if (kind == ActionKind.SHIFT && otherKind == ActionKind.REDUCE) {
                return Resolution.SECOND;
            }
            if (kind == ActionKind.REDUCE && otherKind == ActionKind.SHIFT) {
                return Resolution.FIRST;
            }
        }
        return Resolution.NONE;
    }

    public void printTables(Grammar grammar, List<ItemSet> itemSets) {
        Map<Symbol, ItemSet> transitions;
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        for (Symbol sym : grammar.syms) {
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        System.out.println("Transition Table");
        System.out.println("----------------");
        for (Symbol sym : grammar.syms) {
            System.out.print("\t" + sym + ",");
        }
        System.out.println();
        for (ItemSet set : itemSets) {
            transitions = this.map.get(set);
            System.out.print("S" + set.id());
            for (Symbol sym : grammar.syms) {
                if (transitions.containsKey(sym)) {
                    System.out.print("\tS" + transitions.get(sym).id() + ",");
                    continue;
                }
                System.out.print("\t,");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Action Table");
        System.out.println("------------");
        for (Symbol sym : terminals) {
            System.out.print("\t" + sym + ",");
        }
        System.out.println();
        for (ItemSet set : itemSets) {
            System.out.print("S" + set.id());
            Map<Symbol, Action> setActions = this.actions.get(set);
            for (Symbol sym : terminals) {
                if (setActions.containsKey(sym)) {
                    Action action = setActions.get(sym);
                    System.out.print("\t" + action.code() + ",");
                    continue;
                }
                System.out.print("\t,");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Goto Table");
        System.out.println("----------");
        for (Symbol sym : nonterminals) {
            System.out.print("\t" + sym + ",");
        }
        System.out.println();
        for (ItemSet set : itemSets) {
            transitions = this.map.get(set);
            System.out.print("S" + set.id());
            for (Symbol sym : nonterminals) {
                if (transitions.containsKey(sym)) {
                    System.out.print("\tS" + transitions.get(sym).id() + ",");
                    continue;
                }
                System.out.print("\t,");
            }
            System.out.println();
        }
    }

    public void printConflicts(ProblemHandler problems, Grammar grammar) {
        HashMap map = new HashMap();
        for (Conflict conflict : this.conflicts) {
            if (!map.containsKey(conflict.set)) {
                map.put(conflict.set, new ArrayList());
            }
            ((Collection)map.get(conflict.set)).add(conflict);
        }
        StringBuilder message = new StringBuilder();
        if (!map.isEmpty()) {
            message.append("grammar contains conflicts:");
        }
        for (Map.Entry entry : map.entrySet()) {
            for (Conflict conflict : (Collection)entry.getValue()) {
                message.append(String.format("%n  %s", conflict));
            }
            ItemSet set = (ItemSet)entry.getKey();
            Conflict first = (Conflict)((Collection)entry.getValue()).iterator().next();
            message.append(String.format("%nContext:", new Object[0]));
            for (Item it : set.relatedItems(first.sym)) {
                message.append(String.format("%n  %s", it));
            }
        }
        if (message.length() > 0) {
            problems.error(message.toString());
        }
        for (Conflict conflict : this.conflicts) {
            if (!grammar.nonassoc(conflict.sym.name())) continue;
            problems.errorf("Symbol %s is non-associative, but there are conflicts including the symbol.", conflict.sym.name());
        }
    }

    static enum SelectedAction {
        SHIFT,
        REDUCE,
        NONE;

    }

    static enum Resolution {
        FIRST,
        SECOND,
        NONE;

    }
}

