/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver.ast;

import java.util.Iterator;
import org.extendj.neobeaver.Parser;
import org.extendj.neobeaver.ast.ASTState;
import org.extendj.neobeaver.ast.GVisitor;
import org.extendj.neobeaver.ast.List;
import org.extendj.neobeaver.ast.Opt;

public class ASTNode<T extends ASTNode>
implements Cloneable,
Parser.Symbol {
    Parser.SourcePosition position;
    private int childIndex = -1;
    public static final boolean generatedWithCacheCycle = true;
    protected ASTNode parent;
    protected ASTNode[] children;
    private static ASTState state = new ASTState();
    protected int numChildren;

    public ASTNode setPosition(Parser.Symbol sym) {
        this.position = sym.getPosition();
        return this;
    }

    @Override
    public Parser.SourcePosition getPosition() {
        if (this.position != null) {
            return this.position;
        }
        for (ASTNode child : this.astChildren()) {
            Parser.SourcePosition pos = child.getPosition();
            if (pos == null) continue;
            return pos;
        }
        return null;
    }

    public void accept(GVisitor vis) {
        throw new Error("Missing accept method.");
    }

    public ASTNode() {
        this.init$Children();
    }

    public void init$Children() {
    }

    public int getIndexOfChild(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node.childIndex >= 0) {
            return node.childIndex;
        }
        for (int i = 0; this.children != null && i < this.children.length; ++i) {
            if (this.children[i] != node) continue;
            node.childIndex = i;
            return i;
        }
        return -1;
    }

    public final ASTState state() {
        return state;
    }

    public static final ASTState resetState() {
        state = new ASTState();
        return state;
    }

    public Iterator<T> astChildIterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ASTNode.this.getNumChild();
            }

            @Override
            public T next() {
                return this.hasNext() ? (Object)ASTNode.this.getChild(this.index++) : null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<T> astChildren() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return ASTNode.this.astChildIterator();
            }
        };
    }

    public T getChild(int i) {
        T child = this.getChildNoTransform(i);
        return child;
    }

    public void addChild(T node) {
        this.setChild((ASTNode)node, this.getNumChildNoTransform());
    }

    public T getChildNoTransform(int i) {
        if (this.children == null) {
            return null;
        }
        ASTNode child = this.children[i];
        return (T)child;
    }

    protected int numChildren() {
        return this.numChildren;
    }

    public int getNumChild() {
        return this.numChildren();
    }

    public final int getNumChildNoTransform() {
        return this.numChildren();
    }

    public void setChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1 > 4 || !(this instanceof List) ? i + 1 : 4];
        } else if (i >= this.children.length) {
            ASTNode[] c = new ASTNode[i << 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = node;
        if (i >= this.numChildren) {
            this.numChildren = i + 1;
        }
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void insertChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1 > 4 || !(this instanceof List) ? i + 1 : 4];
            this.children[i] = node;
        } else {
            ASTNode[] c = new ASTNode[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            c[i] = node;
            if (i < this.children.length) {
                System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
                for (int j = i + 1; j < c.length; ++j) {
                    if (c[j] == null) continue;
                    c[j].childIndex = j;
                }
            }
            this.children = c;
        }
        ++this.numChildren;
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void removeChild(int i) {
        if (this.children != null) {
            ASTNode child = this.children[i];
            if (child != null) {
                child.parent = null;
                child.childIndex = -1;
            }
            if (this instanceof List || this instanceof Opt) {
                System.arraycopy(this.children, i + 1, this.children, i, this.children.length - i - 1);
                this.children[this.children.length - 1] = null;
                --this.numChildren;
                for (int j = i; j < this.numChildren; ++j) {
                    if (this.children[j] == null) continue;
                    child = this.children[j];
                    child.childIndex = j;
                }
            } else {
                this.children[i] = null;
            }
        }
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    public void flushTreeCache() {
        this.flushCache();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].flushTreeCache();
            }
        }
    }

    public void flushCache() {
        this.flushAttrAndCollectionCache();
    }

    public void flushAttrAndCollectionCache() {
        this.flushAttrCache();
        this.flushCollectionCache();
    }

    public void flushAttrCache() {
    }

    public void flushCollectionCache() {
    }

    public ASTNode<T> clone() throws CloneNotSupportedException {
        ASTNode node = (ASTNode)super.clone();
        node.flushAttrAndCollectionCache();
        return node;
    }

    public ASTNode<T> copy() {
        try {
            Object node = this.clone();
            ((ASTNode)node).parent = null;
            if (this.children != null) {
                ((ASTNode)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public ASTNode<T> fullCopy() {
        return this.treeCopyNoTransform();
    }

    public ASTNode<T> treeCopyNoTransform() {
        ASTNode<T> tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode<T> child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public ASTNode<T> treeCopy() {
        ASTNode<T> tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    public void doFullTraversal() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).doFullTraversal();
        }
    }

    protected boolean is$Equal(ASTNode n1, ASTNode n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.is$Equal(n2);
    }

    protected boolean is$Equal(ASTNode node) {
        if (this.getClass() != node.getClass()) {
            return false;
        }
        if (this.numChildren != node.numChildren) {
            return false;
        }
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] == null && node.children[i] != null) {
                return false;
            }
            if (this.children[i].is$Equal(node.children[i])) continue;
            return false;
        }
        return true;
    }

    public ASTNode rewrittenNode() {
        throw new Error("rewrittenNode is undefined for ASTNode");
    }
}

