/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.extendj.neobeaver.Action;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.Reduce;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple3;

public class Item {
    public final Rule rule;
    public final int dot;

    public Item(Rule rule, int dot) {
        this.rule = rule;
        this.dot = dot;
    }

    public Collection<Item> extension(Grammar grammar) {
        if (this.dot < this.rule.rhs.size()) {
            Symbol afterDot = this.rule.rhs.get(this.dot);
            return grammar.extension(afterDot);
        }
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.rule.lhs + " =");
        for (int i = 0; i < this.rule.rhs.size(); ++i) {
            if (i == this.dot) {
                buf.append(" .");
            }
            buf.append(" ").append(this.rule.rhs.get(i));
        }
        if (this.dot == this.rule.rhs.size()) {
            buf.append(" .");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.rule.hashCode() ^ this.dot;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Item) {
            Item other = (Item)obj;
            return this.dot == other.dot && this.rule.equals(other.rule);
        }
        return false;
    }

    public boolean canAdvance() {
        return this.dot < this.rule.rhs.size();
    }

    public Item advance() {
        if (this.dot >= this.rule.rhs.size()) {
            throw new Error("Can not advance dot in item past end.");
        }
        return new Item(this.rule, this.dot + 1);
    }

    public Item baseItem() {
        return this;
    }

    public Collection<Tuple3<ItemSet, Symbol, Action>> reduceActions(Grammar grammar, ItemSet set) {
        ArrayList<Tuple3<ItemSet, Symbol, Action>> actions = new ArrayList<Tuple3<ItemSet, Symbol, Action>>();
        Reduce action = new Reduce(this.rule);
        for (Symbol sym : grammar.follow(this.rule.lhs)) {
            actions.add(new Tuple3<ItemSet, Symbol, Reduce>(set, sym, action));
        }
        return actions;
    }

    public Collection<Symbol> followSyms() {
        return Collections.emptyList();
    }

    public boolean related(Symbol sym) {
        return this.dot < this.rule.rhs.size() && this.rule.rhs.get(this.dot) == sym;
    }
}

