/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.GrammarBuilder;
import org.extendj.neobeaver.ListComponent;
import org.extendj.neobeaver.OptionalComponent;
import org.extendj.neobeaver.ProblemHandler;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.SymbolCache;
import org.extendj.neobeaver.TraceEvent;
import org.extendj.neobeaver.TraceHandler;
import org.extendj.neobeaver.ast.ASTNode;
import org.extendj.neobeaver.ast.ClassDecl;
import org.extendj.neobeaver.ast.EmbedCode;
import org.extendj.neobeaver.ast.GComponent;
import org.extendj.neobeaver.ast.GDecl;
import org.extendj.neobeaver.ast.GGrammar;
import org.extendj.neobeaver.ast.GPrecedence;
import org.extendj.neobeaver.ast.GProduction;
import org.extendj.neobeaver.ast.GRule;
import org.extendj.neobeaver.ast.GSym;
import org.extendj.neobeaver.ast.GVisitor;
import org.extendj.neobeaver.ast.Goal;
import org.extendj.neobeaver.ast.HeaderCode;
import org.extendj.neobeaver.ast.LeftAssoc;
import org.extendj.neobeaver.ast.List;
import org.extendj.neobeaver.ast.NonAssoc;
import org.extendj.neobeaver.ast.PackageDecl;
import org.extendj.neobeaver.ast.RightAssoc;
import org.extendj.neobeaver.ast.Terminals;
import org.extendj.neobeaver.ast.TypeOf;

public class BeaverParserBuilder {
    private Symbol goalSym;
    private java.util.List<Rule> rules;
    private Stack<GDecl> stack;
    private Map<String, String> typeMap;
    private SymbolCache cache;
    private Set<String> left;
    private Set<String> right;
    private Set<String> nonassoc;
    private Set<String> assoc;
    private Map<String, Integer> precedence;
    private Set<Symbol> terminals;
    private Set<String> terminalNames;
    private String packageName = "";
    private boolean alreadyDefinedClassName = false;
    private String className = "Parser";
    private String header = "";
    private String embed = "";
    private int nextPrecedence = 1;
    private final ProblemHandler problems;

    public BeaverParserBuilder(ProblemHandler problems) {
        this.problems = problems;
        this.goalSym = Symbol.EOF;
        this.rules = new ArrayList<Rule>();
        this.stack = new Stack();
        this.typeMap = new HashMap<String, String>();
        this.cache = new SymbolCache();
        this.left = new HashSet<String>();
        this.right = new HashSet<String>();
        this.nonassoc = new HashSet<String>();
        this.assoc = new HashSet<String>();
        this.precedence = new HashMap<String, Integer>();
        this.terminals = new HashSet<Symbol>();
        this.terminalNames = new HashSet<String>();
    }

    public Grammar build(TraceHandler trace) {
        return GrammarBuilder.build(trace, this.rules, this.terminals, this.goalSym, this.embed, this.header, this.className, this.packageName, this.left, this.right, this.nonassoc, this.precedence);
    }

    public void defaultParserName(String defaultParserName) {
        this.className = defaultParserName;
    }

    public void grammarSpec(GGrammar grammarSpec, TraceHandler trace) {
        try (TraceEvent ignored1 = trace.event("parse");){
            GVisitor visitor;
            try (TraceEvent ignored2 = trace.event("typeMap");){
                visitor = new FirstPass();
                visitor.visit(grammarSpec);
            }
            ignored2 = trace.event("productions");
            try {
                visitor = new SecondPass();
                visitor.visit(grammarSpec);
            }
            finally {
                if (ignored2 != null) {
                    ignored2.close();
                }
            }
        }
    }

    private void parseAssocRules(List<GSym> symList, Set<String> assocSet) {
        for (GSym sym : symList) {
            String name = sym.getName();
            if (this.assoc.contains(name)) {
                this.problems.warnf("associativity already specified for %s", name);
                continue;
            }
            this.precedence.put(name, this.nextPrecedence++);
            this.assoc.add(name);
            assocSet.add(name);
        }
    }

    private void parseComponents(GRule rule, java.util.List<Symbol> rhs, java.util.List<String> names) {
        HashSet<String> usedNames = new HashSet<String>();
        for (GComponent com : rule.getGComponentList()) {
            String actionName;
            String quantifier;
            Symbol sym = this.parseSymbol(com);
            switch (quantifier = com.getQuantifier()) {
                case "": {
                    rhs.add(sym);
                    break;
                }
                case "*": {
                    rhs.add(ListComponent.buildOptional(sym, this.cache));
                    break;
                }
                case "+": {
                    rhs.add(ListComponent.build(sym, this.cache));
                    break;
                }
                case "?": {
                    rhs.add(OptionalComponent.build(sym, this.cache));
                    break;
                }
                default: {
                    throw new Error("Unknown quantifier: " + quantifier);
                }
            }
            if (com.hasActionName()) {
                actionName = com.getActionName().getName();
            } else {
                actionName = sym.name();
                int suffix = 2;
                while (usedNames.contains(actionName)) {
                    actionName = sym.name() + suffix;
                    ++suffix;
                }
            }
            if (usedNames.contains(actionName)) {
                this.problems.errorf("%s: cannot reuse component name \"%s\" in this production!", rule.getPosition(), actionName);
                continue;
            }
            usedNames.add(actionName);
            names.add(actionName);
        }
    }

    private Symbol parseSymbol(GComponent sym) {
        String name = sym.getName();
        if (this.cache.contains(name)) {
            return this.cache.get(name);
        }
        this.problems.warnf("%s: implicit declaration of terminal symbol [%s].", sym.getPosition(), name);
        Symbol component = this.cache.terminal(name);
        component.setPosition(sym.getPosition());
        return component;
    }

    class SecondPass
    implements GVisitor {
        SecondPass() {
        }

        @Override
        public void visit(GGrammar grammar) {
            for (GDecl decl : grammar.getGDeclList()) {
                decl.accept(this);
            }
        }

        @Override
        public void visit(GProduction prod) {
            Symbol lhs;
            String name = prod.getName();
            String lhsType = BeaverParserBuilder.this.typeMap.containsKey(name) ? (String)BeaverParserBuilder.this.typeMap.get(name) : "Symbol";
            if (BeaverParserBuilder.this.cache.contains(name)) {
                lhs = BeaverParserBuilder.this.cache.get(name);
            } else {
                lhs = BeaverParserBuilder.this.cache.nta(name);
                lhs.setPosition(prod.getPosition());
            }
            for (GRule rule : prod.getGRuleList()) {
                String precedenceSym;
                ArrayList<Symbol> rhs = new ArrayList<Symbol>();
                ArrayList<String> names = new ArrayList<String>();
                BeaverParserBuilder.this.parseComponents(rule, rhs, names);
                String string = precedenceSym = rule.hasPrecedence() ? rule.getPrecedence().getName() : "";
                if (rule.hasAction()) {
                    String action = rule.getAction().getCode();
                    BeaverParserBuilder.this.rules.add(new Rule(-1, lhs, rhs, action, names, lhsType, precedenceSym));
                    continue;
                }
                BeaverParserBuilder.this.rules.add(new Rule(-1, lhs, rhs, "", names, lhsType, precedenceSym));
            }
        }

        @Override
        public void visit(GRule rule) {
        }

        @Override
        public void visit(GPrecedence precedence) {
        }

        @Override
        public void visit(HeaderCode code) {
        }

        @Override
        public void visit(EmbedCode code) {
        }

        @Override
        public void visit(Terminals list) {
            for (GSym t : list.getSymList()) {
                String name = t.getName();
                if (BeaverParserBuilder.this.terminalNames.contains(name)) {
                    BeaverParserBuilder.this.problems.warnf("duplicate terminal token declared: %s", name);
                    continue;
                }
                Symbol term = BeaverParserBuilder.this.cache.terminal(name);
                term.setPosition(t.getPosition());
                BeaverParserBuilder.this.terminals.add(term);
                BeaverParserBuilder.this.terminalNames.add(name);
            }
        }

        @Override
        public void visit(TypeOf typeOf) {
        }

        @Override
        public void visit(Goal goal) {
        }

        @Override
        public void visit(ClassDecl classDecl) {
            if (BeaverParserBuilder.this.alreadyDefinedClassName) {
                BeaverParserBuilder.this.problems.warn("redeclaring parser class name!");
            }
            BeaverParserBuilder.this.alreadyDefinedClassName = true;
            BeaverParserBuilder.this.className = classDecl.getName();
            if (BeaverParserBuilder.this.className.isEmpty()) {
                BeaverParserBuilder.this.problems.warn("empty class name!");
            }
        }

        @Override
        public void visit(PackageDecl packageDecl) {
            if (!BeaverParserBuilder.this.packageName.isEmpty()) {
                BeaverParserBuilder.this.problems.warn("redeclaring package name!");
            }
            BeaverParserBuilder.this.packageName = packageDecl.getName();
        }

        @Override
        public void visit(LeftAssoc assoc) {
            BeaverParserBuilder.this.parseAssocRules(assoc.getSymList(), BeaverParserBuilder.this.left);
        }

        @Override
        public void visit(RightAssoc assoc) {
            BeaverParserBuilder.this.parseAssocRules(assoc.getSymList(), BeaverParserBuilder.this.right);
        }

        @Override
        public void visit(NonAssoc assoc) {
            BeaverParserBuilder.this.parseAssocRules(assoc.getSymList(), BeaverParserBuilder.this.nonassoc);
        }
    }

    class FirstPass
    implements GVisitor {
        FirstPass() {
        }

        @Override
        public void visit(GProduction prod) {
            Symbol lhs;
            String name = prod.getName();
            if (prod.hasType()) {
                this.addType(prod, name, prod.getType().getName());
            }
            if (BeaverParserBuilder.this.cache.contains(name)) {
                lhs = BeaverParserBuilder.this.cache.get(name);
            } else {
                lhs = BeaverParserBuilder.this.cache.nta(name);
                lhs.setPosition(prod.getPosition());
            }
            lhs.setPosition(prod.getPosition());
            if (BeaverParserBuilder.this.goalSym == Symbol.EOF) {
                BeaverParserBuilder.this.goalSym = lhs;
            }
        }

        @Override
        public void visit(GGrammar grammar) {
            for (GDecl decl : grammar.getGDeclList()) {
                decl.accept(this);
            }
        }

        @Override
        public void visit(GRule prod) {
        }

        @Override
        public void visit(GPrecedence prod) {
        }

        @Override
        public void visit(HeaderCode prod) {
            BeaverParserBuilder.this.header = BeaverParserBuilder.this.header + prod.getCode();
        }

        @Override
        public void visit(EmbedCode prod) {
            BeaverParserBuilder.this.embed = BeaverParserBuilder.this.embed + prod.getCode();
        }

        @Override
        public void visit(Terminals prod) {
        }

        @Override
        public void visit(TypeOf nta) {
            this.addType(nta, nta.getName(), nta.getType());
        }

        @Override
        public void visit(Goal nta) {
            if (BeaverParserBuilder.this.goalSym == Symbol.EOF) {
                BeaverParserBuilder.this.goalSym = BeaverParserBuilder.this.cache.nta(nta.getName());
                BeaverParserBuilder.this.goalSym.setPosition(nta.getPosition());
            } else {
                BeaverParserBuilder.this.problems.warnf("%s multiple goal symbols specified.", nta.getPosition());
            }
        }

        @Override
        public void visit(ClassDecl prod) {
        }

        @Override
        public void visit(PackageDecl prod) {
        }

        @Override
        public void visit(LeftAssoc assoc) {
        }

        @Override
        public void visit(RightAssoc assoc) {
        }

        @Override
        public void visit(NonAssoc assoc) {
        }

        private void addType(ASTNode position, String name, String type) {
            if (BeaverParserBuilder.this.typeMap.containsKey(name) && !((String)BeaverParserBuilder.this.typeMap.get(name)).equals(type)) {
                BeaverParserBuilder.this.problems.warnf("%s: conflicting type declarations for %s: new type %s is not same as previous type %s", position.getPosition(), name, type, BeaverParserBuilder.this.typeMap.get(name));
            }
            BeaverParserBuilder.this.typeMap.put(name, type);
        }
    }
}

