/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import org.extendj.neobeaver.Action;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.MyParser;
import org.extendj.neobeaver.ProblemHandler;
import org.extendj.neobeaver.Reduce;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Shift;
import org.extendj.neobeaver.SymSet;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.TraceEvent;
import org.extendj.neobeaver.TraceHandler;
import org.extendj.neobeaver.TransitionTable;
import org.extendj.neobeaver.Tuple;
import org.extendj.neobeaver.Tuple3;
import org.extendj.neobeaver.Util;

public class Grammar {
    public static final boolean VERBOSE = System.getProperty("NBVerbose", "").equals("true");
    private final List<Rule> originalRules;
    public final List<Rule> rules;
    public final Symbol goalSym;
    public final Set<Symbol> syms;
    public final Map<Integer, Symbol> symIndex;
    private final BitSet nullable;
    private final Map<Symbol, SymSet> first;
    private final Map<Symbol, Set<Symbol>> follow;
    public final Map<Symbol, Collection<Rule>> byLhs;
    private final Item goalItem;
    private final String embed;
    private final String header;
    public final String className;
    public final String packageName;
    private final Set<String> left;
    private final Set<String> right;
    private final Set<String> nonassoc;
    private final Map<String, Integer> precedence;
    private int nextItemId = 1;

    public Grammar(List<Rule> originalRules, List<Rule> rules, Symbol goalSym, Rule goalRule, Set<Symbol> syms, BitSet nullable, Map<Symbol, Set<Symbol>> first, Map<Symbol, Set<Symbol>> follow, Map<Symbol, Collection<Rule>> byLhs, String embed, String header, String className, String packageName, Set<String> left, Set<String> right, Set<String> nonassoc, Map<String, Integer> precedence) {
        this.originalRules = originalRules;
        this.rules = rules;
        this.goalSym = goalSym;
        this.syms = syms;
        this.nullable = nullable;
        this.first = new HashMap<Symbol, SymSet>();
        this.follow = follow;
        this.byLhs = byLhs;
        this.goalItem = new Item(goalRule, 0, Symbol.EOF);
        this.embed = embed;
        this.header = header;
        this.className = className;
        this.packageName = packageName;
        this.left = left;
        this.right = right;
        this.nonassoc = nonassoc;
        this.precedence = precedence;
        this.symIndex = new HashMap<Integer, Symbol>(syms.size());
        for (Symbol symbol : syms) {
            if (this.symIndex.containsKey(symbol.id())) {
                throw new Error("Duplicate symbol ID: " + symbol.id());
            }
            this.symIndex.put(symbol.id(), symbol);
        }
        for (Map.Entry entry : first.entrySet()) {
            this.first.put((Symbol)entry.getKey(), SymSet.of((Set)entry.getValue(), this));
        }
    }

    public static String typeOf(Symbol symbol, Collection<Rule> rules) {
        for (Rule rule : rules) {
            if (rule.lhs != symbol) continue;
            return rule.type();
        }
        return "Symbol";
    }

    public static Collection<Rule> canonicalRules(Collection<Rule> rules) {
        HashSet<Rule> result = new HashSet<Rule>();
        for (Rule rule : rules) {
            result.addAll(rule.canonical());
            result.addAll(rule.extraRules());
        }
        return result;
    }

    public MyParser buildParser(ProblemHandler problems, TraceHandler trace) {
        TransitionTable table;
        HashMap<ItemSet, ItemSet> hashMap;
        List<ItemSet> itemSets;
        ItemSet goal = this.makeGoalSet(this.goalItem);
        LinkedHashMap<ItemSet, ItemSet> baseCores = new LinkedHashMap<ItemSet, ItemSet>();
        LinkedHashSet<ItemSet> allSets = new LinkedHashSet<ItemSet>();
        ArrayList<ItemSet> newSets = new ArrayList<ItemSet>();
        newSets.add(goal);
        ArrayList<ItemSet> next = new ArrayList<ItemSet>();
        baseCores.put(goal.baseCore(), goal);
        ArrayList<Tuple3<ItemSet, ItemSet, Symbol>> transitions = new ArrayList<Tuple3<ItemSet, ItemSet, Symbol>>();
        try (TraceEvent ignored = trace.event("transitions");){
            while (!newSets.isEmpty()) {
                for (ItemSet itemSet : newSets) {
                    allSets.add(itemSet);
                    TraceEvent traceEvent = trace.event("follow cores");
                    try {
                        Iterator<Item> source = itemSet.baseCore();
                        for (Tuple<Symbol, ItemSet> tuple : itemSet.followCores().values()) {
                            TraceEvent ignored4;
                            Symbol sym = (Symbol)tuple.first;
                            ItemSet follow = (ItemSet)tuple.second;
                            ItemSet baseCore = follow.baseCore();
                            transitions.add(Tuple.of(source, baseCore, sym));
                            ItemSet existing = (ItemSet)baseCores.get(baseCore);
                            if (existing != null) {
                                ignored4 = trace.event("merge");
                                try {
                                    for (Item it : Iterables.concat(itemSet.items.values(), itemSet.extension.values())) {
                                        if (!it.canAdvance()) continue;
                                        Item adv = it.advance();
                                        if (existing.items.containsKey(adv)) {
                                            it.succ.add(existing.items.get(adv));
                                        }
                                        if (!existing.extension.containsKey(adv)) continue;
                                        it.succ.add(existing.extension.get(adv));
                                    }
                                    continue;
                                }
                                finally {
                                    if (ignored4 != null) {
                                        ignored4.close();
                                    }
                                    continue;
                                }
                            }
                            ignored4 = trace.event("add item set");
                            try {
                                ItemSet extended = new ItemSet(-1, follow, this.extension(follow.items.values()));
                                next.add(extended);
                                baseCores.put(baseCore, extended);
                            }
                            finally {
                                if (ignored4 == null) continue;
                                ignored4.close();
                            }
                        }
                    }
                    finally {
                        if (traceEvent == null) continue;
                        traceEvent.close();
                    }
                }
                ArrayList<ItemSet> tmp = newSets;
                newSets = next;
                next = tmp;
                next.clear();
            }
        }
        System.err.format("Grammar has %d rules and %d states.%n", this.rules.size(), allSets.size());
        ignored = trace.event("propagate follows");
        try {
            ArrayList<Item> changed = new ArrayList<Item>();
            for (ItemSet itemSet : allSets) {
                for (Item item : itemSet.items.values()) {
                    changed.add(item);
                }
                for (Item item : itemSet.extension.values()) {
                    changed.add(item);
                }
            }
            ArrayList<Item> arrayList = new ArrayList<Item>();
            while (changed.size() > 0) {
                for (Object item : changed) {
                    for (Item succ : ((Item)item).succ) {
                        if (!succ.follow.addAll(((Item)item).follow)) continue;
                        arrayList.add(succ);
                    }
                }
                changed.clear();
                changed.addAll(arrayList);
                arrayList.clear();
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        ArrayList<Tuple3<ItemSet, Symbol, Action>> actions = new ArrayList<Tuple3<ItemSet, Symbol, Action>>();
        try (TraceEvent traceEvent = trace.event("enumerate");){
            itemSets = Grammar.enumerateItems(baseCores.values());
        }
        try (TraceEvent traceEvent = trace.event("coreMap");){
            hashMap = new HashMap<ItemSet, ItemSet>();
            for (ItemSet itemSet : itemSets) {
                hashMap.put(itemSet.baseCore(), itemSet);
            }
        }
        ItemSet itemSet = (ItemSet)hashMap.get(goal.baseCore());
        actions.add(Tuple.of(itemSet, Symbol.GOAL, Action.ACCEPT));
        try (TraceEvent traceEvent = trace.event("TransitionTables.build");){
            table = TransitionTable.build(this, problems, this.syms, itemSets, itemSet, hashMap, transitions, actions);
        }
        return new MyParser(this, table, itemSet, itemSets);
    }

    public int precedence(String token) {
        if (this.precedence.containsKey(token)) {
            return this.precedence.get(token);
        }
        return Integer.MAX_VALUE;
    }

    public boolean left(String token) {
        return this.left.contains(token);
    }

    public boolean right(String token) {
        return this.right.contains(token);
    }

    public boolean nonassoc(String token) {
        return this.nonassoc.contains(token);
    }

    private static List<ItemSet> enumerateItems(Collection<ItemSet> items) {
        int id = 1;
        ArrayList<ItemSet> result = new ArrayList<ItemSet>();
        for (ItemSet item : items) {
            result.add(new ItemSet(id, item.core, item.extension.values()));
            ++id;
        }
        return result;
    }

    private ItemSet makeGoalSet(Item item) {
        Set<Item> items = Collections.singleton(item);
        ItemSet core = new ItemSet(this.nextItemId, items);
        ItemSet goalSet = new ItemSet(this.nextItemId, core, this.extension(items));
        ++this.nextItemId;
        return goalSet;
    }

    private Collection<Item> extension(Collection<Item> items) {
        HashMap<Item, Item> extension = new HashMap<Item, Item>();
        HashSet<Item> newItems = new HashSet<Item>(items);
        HashSet<Object> next = new HashSet();
        while (!newItems.isEmpty()) {
            for (Item item : newItems) {
                for (Item ext : item.immediateExtension(this)) {
                    if (extension.containsKey(ext)) {
                        if (!((Item)extension.get((Object)ext)).follow.addAll(ext.follow)) continue;
                        next.add(ext);
                        continue;
                    }
                    extension.put(ext, ext);
                    next.add(ext);
                }
                LinkedList sa = new LinkedList();
                for (Item succ : item.succ) {
                    if (!extension.containsKey(succ) || extension.get(succ) == succ) continue;
                    sa.add(extension.get(succ));
                }
                item.succ.addAll(sa);
            }
            HashSet<Item> tmp = newItems;
            newItems = next;
            next = tmp;
            next.clear();
        }
        return extension.values();
    }

    public SymSet first(Symbol sym) {
        return this.first.get(sym);
    }

    public boolean nullable(Symbol sym) {
        return this.nullable.get(sym.id());
    }

    public Collection<Symbol> follow(Symbol lhs) {
        return this.follow.get(lhs);
    }

    private static Tuple<Integer, Integer> range(Set<Integer> sortedSyms) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Integer value : sortedSyms) {
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        return Tuple.of(min, max);
    }

    private static boolean allSame(Collection<Integer> values) {
        return false;
    }

    public void printTables(MyParser parser) {
        TransitionTable transitions = parser.transitions;
        List<ItemSet> itemSets = parser.itemSets;
        LinkedHashMap usedSyms = new LinkedHashMap();
        for (ItemSet itemSet : itemSets) {
            HashSet<Symbol> syms = new HashSet<Symbol>();
            syms.addAll(transitions.actions.get(itemSet).keySet());
            syms.addAll(transitions.map.get(itemSet).keySet());
            usedSyms.put(itemSet, syms);
        }
        HashMap<Symbol, Integer> occurrences = new HashMap<Symbol, Integer>();
        for (Set symbols : usedSyms.values()) {
            for (Object sym : symbols) {
                if (occurrences.containsKey(sym)) {
                    occurrences.put((Symbol)sym, (Integer)occurrences.get(sym) + 1);
                    continue;
                }
                occurrences.put((Symbol)sym, 0);
            }
        }
        occurrences.put(Symbol.EOF, Integer.MAX_VALUE);
        ArrayList arrayList = new ArrayList(occurrences.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Symbol, Integer>>(){

            @Override
            public int compare(Map.Entry<Symbol, Integer> o1, Map.Entry<Symbol, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        for (Map.Entry entry : arrayList) {
            Symbol sym = (Symbol)entry.getKey();
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        HashMap<Symbol, Integer> sym2id = new HashMap<Symbol, Integer>();
        HashMap<Integer, Symbol> hashMap = new HashMap<Integer, Symbol>();
        int nextSymId = 0;
        for (Symbol sym : terminals) {
            sym2id.put(sym, nextSymId);
            hashMap.put(nextSymId, sym);
            ++nextSymId;
        }
        for (Symbol sym : nonterminals) {
            sym2id.put(sym, nextSymId);
            hashMap.put(nextSymId, sym);
            ++nextSymId;
        }
        for (ItemSet state : itemSets) {
            System.out.format("S%d%n", state.id());
            Map<Symbol, Action> setActions = transitions.actions.get(state);
            Map<Symbol, ItemSet> trans = transitions.map.get(state);
            for (Symbol tok : terminals) {
                Action action = setActions.get(tok);
                if (action instanceof Reduce) {
                    Reduce reduce = (Reduce)action;
                    System.out.format("    %s: REDUCE %s%n", tok, reduce.rule);
                    continue;
                }
                if (!(action instanceof Shift)) continue;
                Shift shift = (Shift)action;
                System.out.format("    %s: SHIFT; goto S%d%n", tok, shift.next.id());
            }
            for (Symbol sym : nonterminals) {
                ItemSet next = trans.get(sym);
                if (next != null) {
                    System.out.format("    %s: SHIFT; goto S%d%n", sym, next.id());
                    continue;
                }
                Action action = setActions.get(sym);
                if (action != Action.ACCEPT) continue;
                System.out.format("    %s: ACCEPT%n", sym);
            }
        }
    }

    public void printBeaverSpec(PrintStream out, MyParser parser) throws IOException {
        if (!this.packageName.isEmpty()) {
            out.format("%%package \"%s\";%n", this.packageName);
        }
        if (!this.header.isEmpty()) {
            out.format("%%header {%n%s%n};%n", this.header);
        }
        if (!this.embed.isEmpty()) {
            out.format("%%embed {%n%s%n};%n", this.embed);
        }
        TransitionTable transitions = parser.transitions;
        List<ItemSet> itemSets = parser.itemSets;
        HashSet<Symbol> usedSyms = new HashSet<Symbol>();
        for (ItemSet state : itemSets) {
            usedSyms.addAll(transitions.actions.get(state).keySet());
            usedSyms.addAll(transitions.map.get(state).keySet());
        }
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        for (Symbol sym : usedSyms) {
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        for (Symbol sym : terminals) {
            out.format("%%terminals %s;%n", sym);
        }
        for (Symbol sym : nonterminals) {
            String type = Grammar.typeOf(sym, this.rules);
            if (type.equals("Symbol")) continue;
            out.format("%%typeof %s = \"%s\";%n", sym.name(), type);
        }
        out.println();
        out.format("%%goal %s;%n", this.goalSym.name());
        out.println();
        for (Symbol sym : nonterminals) {
            out.format("%s =%n", sym.name());
            boolean first = true;
            for (Rule rule : this.originalRules) {
                if (rule.lhs != sym) continue;
                if (first) {
                    first = false;
                    out.print("    ");
                } else {
                    out.print("  | ");
                }
                for (int i = 0; i < rule.rhs.size(); ++i) {
                    if (i > 0) {
                        out.print(" ");
                    }
                    Symbol rhsSym = rule.rhs.get(i);
                    String symName = i < rule.names.size() ? rule.names.get(i) : rhsSym.name();
                    out.format("%s.%s", rhsSym.name(), symName);
                }
                if (!rule.action.isEmpty()) {
                    out.format(" {: %s :}", rule.action);
                }
                out.println();
            }
            out.println("  ;");
        }
    }

    public void printBeaverTestSpec(PrintStream out, MyParser parser) throws IOException {
        if (!this.packageName.isEmpty()) {
            out.format("%%package \"%s\";%n", this.packageName);
        }
        if (!this.header.isEmpty()) {
            out.format("%%header {%n%s%n};%n", this.header);
        }
        if (!this.embed.isEmpty()) {
            out.format("%%embed {%n%s%n};%n", this.embed);
        }
        TransitionTable transitions = parser.transitions;
        List<ItemSet> itemSets = parser.itemSets;
        HashSet<Symbol> usedSyms = new HashSet<Symbol>();
        for (ItemSet state : itemSets) {
            usedSyms.addAll(transitions.actions.get(state).keySet());
            usedSyms.addAll(transitions.map.get(state).keySet());
        }
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        for (Symbol sym : usedSyms) {
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        for (Symbol sym : terminals) {
            out.format("%%terminals %s;%n", sym);
        }
        for (Symbol sym : nonterminals) {
            String type = Grammar.typeOf(sym, this.rules);
            if (type.equals("Symbol")) continue;
            out.format("%%typeof %s = \"%s\";%n", sym.name(), type);
        }
        out.println();
        out.format("%%goal %s;%n", this.goalSym.name());
        out.println();
        for (Symbol sym : nonterminals) {
            out.format("%s =%n", sym.name());
            boolean first = true;
            for (Rule rule : this.originalRules) {
                String symName;
                Symbol rhsSym;
                int i;
                if (rule.lhs != sym) continue;
                if (first) {
                    first = false;
                    out.print("    ");
                } else {
                    out.print("  | ");
                }
                for (i = 0; i < rule.rhs.size(); ++i) {
                    if (i > 0) {
                        out.print(" ");
                    }
                    rhsSym = rule.rhs.get(i);
                    symName = i < rule.names.size() ? rule.names.get(i) : rhsSym.name();
                    out.format("%s.%s", rhsSym.name(), symName);
                }
                out.format(" {: return new Nonterminal(\"%s\"", sym.name());
                for (i = 0; i < rule.rhs.size(); ++i) {
                    rhsSym = rule.rhs.get(i);
                    symName = i < rule.names.size() ? rule.names.get(i) : rhsSym.name();
                    out.format(", %s", symName);
                }
                out.println("); :}");
            }
            out.println("  ;");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printParser(PrintStream out, MyParser parser, boolean debug) {
        void var15_23;
        TransitionTable transitions = parser.transitions;
        List<ItemSet> itemSets = parser.itemSets;
        out.println("// Parser generated by NeoBeaver.");
        if (!this.packageName.isEmpty()) {
            out.format("package %s;%n", this.packageName);
        }
        if (!this.header.isEmpty()) {
            out.println(this.header);
        }
        out.println("import java.io.IOException;");
        out.println("import java.util.Stack;");
        out.println();
        out.format("public class %s {%n", this.className);
        out.println();
        out.println("  /** Interface implemented by scanners that this parser can use. */");
        out.println("  public interface TokenScanner {");
        out.println("    Token nextToken() throws IOException;");
        out.println("  }");
        out.println();
        out.println("  public static class SourcePosition {");
        out.println("    int line, column;");
        out.println();
        out.println("    public SourcePosition(int line, int column) {");
        out.println("      this.line = line;");
        out.println("      this.column = column;");
        out.println("    }");
        out.println();
        out.println("    @Override public String toString() {");
        out.println("      return \"\" + line + \":\" + column;");
        out.println("    }");
        out.println("  }");
        if (!this.embed.isEmpty()) {
            out.format("%s%n", this.embed);
        }
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        for (Symbol sym : this.syms) {
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        HashMap<Symbol, Integer> tok2id = new HashMap<Symbol, Integer>();
        HashMap<Symbol, Integer> sym2id = new HashMap<Symbol, Integer>();
        HashMap<Integer, Symbol> id2sym = new HashMap<Integer, Symbol>();
        int nextSymId = 0;
        for (Symbol sym : terminals) {
            tok2id.put(sym, nextSymId);
            id2sym.put(nextSymId, sym);
            ++nextSymId;
        }
        nextSymId = 0;
        for (Symbol sym : nonterminals) {
            sym2id.put(sym, nextSymId);
            id2sym.put(nextSymId, sym);
            ++nextSymId;
        }
        out.println("  public interface Tokens {");
        for (Symbol sym : terminals) {
            int tokId = (Integer)tok2id.get(sym);
            if (sym.isNamed()) {
                out.format("    int %s = %d;%n", sym.name(), tokId);
                continue;
            }
            if (sym == Symbol.EOF) {
                out.format("    int EOF = %d;%n", tokId);
                continue;
            }
            if (sym.isTerminal()) {
                out.format("    int TOKEN_%d = %d;%n", tokId, tokId);
                continue;
            }
            throw new Error("Can't generate parser with unnamed nonterminal!");
        }
        out.println("  }");
        out.println();
        out.println("  public static class SyntaxError extends Exception {");
        out.println("    private Symbol sym;");
        out.println();
        out.println("    public SyntaxError(Symbol sym) {");
        out.println("      this.sym = sym;");
        out.println("    }");
        out.println();
        out.println("    @Override");
        out.println("    public String getMessage() {");
        out.println("      return String.format(\"syntax error at token \\\"%s\\\" at %s\", sym, sym.getPosition());");
        out.println("    }");
        out.println("  }");
        out.println();
        out.println("  void syntaxError(Symbol sym) throws SyntaxError {");
        out.println("    throw new SyntaxError(sym);");
        out.println("  }");
        out.println();
        out.println("  static Token nextToken(TokenScanner in) throws IOException {");
        out.println("    return in.nextToken();");
        out.println("  }");
        out.println();
        out.println("  private static final boolean DEBUG = System.getProperty(\"debug\", \"\").equalsIgnoreCase(\"true\");");
        out.println();
        out.println("  public Symbol parse(TokenScanner in) throws IOException, SyntaxError {");
        out.println("    Stack<Integer> stateStack = new Stack<Integer>();");
        out.println("    Stack<Symbol> stack = new Stack<Symbol>();");
        out.println("    int state = 1;");
        out.println("    Token next = nextToken(in);");
        out.println("    while (state != -1) {");
        out.println("      if (state == 0) throw new Error(\"parse error\");");
        out.println("      if (DEBUG) {");
        out.println("        System.out.print(\"state:\");");
        out.println("        for (int st : stateStack) {");
        out.println("          System.out.print(\" \" + st);");
        out.println("        }");
        out.println("        System.out.println(\" \" + state);");
        out.println("      }");
        out.println("      switch (state) {");
        int nextId = 0;
        HashMap<Reduce, Integer> reduceActions = new HashMap<Reduce, Integer>();
        for (ItemSet itemSet : itemSets) {
            int state = itemSet.id();
            out.format("        case %d:%n", state);
            Map<Symbol, Action> setActions = transitions.actions.get(itemSet);
            out.println("          if (DEBUG) System.out.format(\"[%s] \", next);");
            out.println("          switch (next.getId()) {");
            for (Symbol tok : terminals) {
                out.format("            case %d: {%n", tok2id.get(tok));
                if (setActions.containsKey(tok)) {
                    Action action = setActions.get(tok);
                    if (action instanceof Reduce) {
                        int symid;
                        Reduce reduce = (Reduce)action;
                        Rule rule = reduce.rule;
                        if (!reduceActions.containsKey(reduce)) {
                            reduceActions.put(reduce, nextId);
                            ++nextId;
                        }
                        int reduceId = (Integer)reduceActions.get(reduce);
                        for (symid = 0; symid < rule.rhs.size(); ++symid) {
                            int id = rule.rhs.size() - symid;
                            String symType = Grammar.typeOf(rule.rhs.get(id - 1), this.rules);
                            out.format("              %s sym%d = (%s) stack.pop();%n", symType, id, symType);
                        }
                        out.format("              Symbol _result = reduce%d(", reduceId);
                        for (int id = 1; id <= rule.rhs.size(); ++id) {
                            if (id > 1) {
                                out.print(", ");
                            }
                            out.format("sym%d", id);
                        }
                        out.println(");");
                        out.println("              stack.push(_result);");
                        for (symid = 1; symid < rule.rhs.size(); ++symid) {
                            out.println("              stateStack.pop();");
                        }
                        if (rule.rhs.isEmpty()) {
                            out.println("              stateStack.push(state);");
                        }
                        out.format("              state = gotos[stateStack.peek()][%d];%n", sym2id.get(rule.lhs));
                    } else if (action instanceof Shift) {
                        Shift shift = (Shift)action;
                        out.println("              stateStack.push(state);");
                        out.println("              stack.push(next);");
                        out.format("              state = %d;%n", shift.next.id());
                        out.println("              next = nextToken(in);");
                    }
                    out.println("              break;");
                } else {
                    out.println("              syntaxError(next);");
                }
                out.println("            }");
            }
            out.println("          }");
            out.println("          break;");
        }
        out.println("    }");
        out.println("    }");
        out.println("    return stack.pop();");
        out.println("  }");
        out.println();
        for (Map.Entry entry : reduceActions.entrySet()) {
            Reduce reduce = (Reduce)entry.getKey();
            int reduceId = (Integer)entry.getValue();
            List<Symbol> rhs = reduce.rule.rhs;
            out.println();
            String lhsType = Grammar.typeOf(reduce.rule.lhs, this.rules);
            out.format("  %s reduce%d(", lhsType, reduceId);
            for (int id = 1; id <= rhs.size(); ++id) {
                if (id > 1) {
                    out.print(", ");
                }
                String symType = Grammar.typeOf(rhs.get(id - 1), this.rules);
                int i = id - 1;
                if (i < reduce.rule.names.size()) {
                    out.format("%s %s", symType, reduce.rule.names.get(i));
                    continue;
                }
                if (rhs.get(i).isTerminal()) {
                    out.format("%s sym%d", symType, id);
                    continue;
                }
                out.format("%s %s", symType, rhs.get(i).name());
            }
            out.println(") {");
            out.format("    // %s%n", reduce.rule);
            out.format("    if (DEBUG) System.out.println(\"%s\");%n", reduce.rule);
            if (!reduce.rule.action.isEmpty()) {
                out.format("    %s%n", reduce.rule.action);
            } else if (rhs.isEmpty()) {
                out.format("    return new Nonterminal(\"%s\");%n", reduce.rule.lhs.name());
            } else if (!reduce.rule.names.isEmpty()) {
                out.format("    return %s;%n", reduce.rule.names.get(reduce.rule.names.size() - 1));
            } else {
                Symbol last = rhs.get(rhs.size() - 1);
                if (last.isTerminal()) {
                    out.format("    return sym%d;%n", rhs.size() - 1);
                } else {
                    out.format("    return %s;%n", last.name());
                }
            }
            out.println("  }");
        }
        HashMap gotoMap = new HashMap();
        for (ItemSet set : itemSets) {
            Map<Symbol, ItemSet> trans = transitions.map.get(set);
            Map<Symbol, Action> setActions = transitions.actions.get(set);
            HashMap<Symbol, Integer> map = new HashMap<Symbol, Integer>();
            for (Symbol sym : nonterminals) {
                ItemSet next = trans.get(sym);
                if (next != null) {
                    map.put(sym, next.id());
                    continue;
                }
                Action action = setActions.get(sym);
                if (action == Action.ACCEPT) {
                    map.put(sym, -1);
                    continue;
                }
                map.put(sym, 0);
            }
            gotoMap.put(set.id(), map);
        }
        out.println();
        out.println("  private static final int[][] gotos = {");
        out.print("    {");
        for (Symbol sym : nonterminals) {
            out.print(" 0,");
        }
        out.println(" },");
        boolean bl = true;
        while (var15_23 <= itemSets.size()) {
            out.print("    {");
            for (Symbol sym : nonterminals) {
                out.print(" " + ((Map)gotoMap.get((int)var15_23)).get(sym) + ",");
            }
            out.println(" },");
            ++var15_23;
        }
        out.println("  };");
        out.println();
        out.println("}");
    }

    public void printBeaverParser(PrintStream out, MyParser parser, TraceHandler trace) throws IOException {
        int id;
        int index;
        Collection<Integer> actions;
        Tuple range;
        if (!this.packageName.isEmpty()) {
            out.format("package %s;%n", this.packageName);
        }
        if (!this.header.isEmpty()) {
            out.format("  %s%n", this.header);
        }
        out.println("import beaver.*;");
        out.println("import java.util.ArrayList;");
        out.println();
        out.println("import java.io.ByteArrayOutputStream;");
        out.println("import java.io.DataOutputStream;");
        out.println("import java.io.IOException;");
        out.println("import java.util.Stack;");
        out.println("import java.util.zip.DeflaterOutputStream;");
        out.println();
        out.println("// This parser was generated by NeoBeaver.");
        out.format("public class %s extends beaver.Parser {%n", this.className);
        if (!this.embed.isEmpty()) {
            out.format("  %s%n", this.embed);
        }
        TransitionTable transitions = parser.transitions;
        List<ItemSet> itemSets = parser.itemSets;
        HashMap usedSyms = new HashMap();
        for (ItemSet itemSet : itemSets) {
            HashSet<Symbol> syms = new HashSet<Symbol>();
            syms.addAll(transitions.actions.get(itemSet).keySet());
            syms.addAll(transitions.map.get(itemSet).keySet());
            usedSyms.put(itemSet, syms);
        }
        HashMap<Symbol, Integer> occurrences = new HashMap<Symbol, Integer>();
        for (Set symbols : usedSyms.values()) {
            for (Object sym : symbols) {
                if (occurrences.containsKey(sym)) {
                    occurrences.put((Symbol)sym, (Integer)occurrences.get(sym) + 1);
                    continue;
                }
                occurrences.put((Symbol)sym, 0);
            }
        }
        occurrences.put(Symbol.EOF, Integer.MAX_VALUE);
        for (Symbol sym : this.syms) {
            if (!sym.isTerminal() || occurrences.containsKey(sym)) continue;
            occurrences.put(sym, Integer.MIN_VALUE);
        }
        ArrayList arrayList = new ArrayList(occurrences.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Symbol, Integer>>(){

            @Override
            public int compare(Map.Entry<Symbol, Integer> o1, Map.Entry<Symbol, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        for (Map.Entry entry : arrayList) {
            Symbol sym = (Symbol)entry.getKey();
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        HashMap<Symbol, Integer> sym2id = new HashMap<Symbol, Integer>();
        HashMap<Integer, Symbol> hashMap = new HashMap<Integer, Symbol>();
        int nextSymId = 0;
        for (Symbol symbol : terminals) {
            sym2id.put(symbol, nextSymId);
            hashMap.put(nextSymId, symbol);
            ++nextSymId;
        }
        for (Symbol symbol : nonterminals) {
            sym2id.put(symbol, nextSymId);
            hashMap.put(nextSymId, symbol);
            ++nextSymId;
        }
        HashMap actionSyms = new HashMap();
        for (ItemSet itemSet : itemSets) {
            HashSet hashSet = new HashSet();
            for (Symbol symbol : transitions.actions.get(itemSet).keySet()) {
                if (!symbol.isTerminal()) continue;
                hashSet.add(sym2id.get(symbol));
            }
            actionSyms.put(itemSet, hashSet);
        }
        HashMap hashMap2 = new HashMap();
        for (ItemSet itemSet : itemSets) {
            HashSet hashSet = new HashSet();
            for (Symbol sym : transitions.actions.get(itemSet).keySet()) {
                if (sym.isTerminal()) continue;
                hashSet.add(sym2id.get(sym));
            }
            for (Symbol sym : transitions.map.get(itemSet).keySet()) {
                if (sym.isTerminal()) continue;
                hashSet.add(sym2id.get(sym));
            }
            hashMap2.put(itemSet, hashSet);
        }
        HashMap<ItemSet, Tuple<Integer, Integer>> hashMap3 = new HashMap<ItemSet, Tuple<Integer, Integer>>();
        for (ItemSet itemSet : itemSets) {
            Set set = (Set)actionSyms.get(itemSet);
            if (set.isEmpty()) continue;
            hashMap3.put(itemSet, Grammar.range(set));
        }
        HashMap<ItemSet, Tuple<Integer, Integer>> hashMap4 = new HashMap<ItemSet, Tuple<Integer, Integer>>();
        for (ItemSet itemSet : itemSets) {
            Set syms = (Set)hashMap2.get(itemSet);
            if (syms.isEmpty()) continue;
            hashMap4.put(itemSet, Grammar.range(syms));
        }
        out.println("  public static class Terminals {");
        for (Symbol symbol : terminals) {
            int tokId = (Integer)sym2id.get(symbol);
            if (symbol.isNamed()) {
                out.format("    public static final short %s = %d;%n", symbol.name(), tokId);
                continue;
            }
            if (symbol == Symbol.EOF) {
                out.format("    public static final short EOF = %d;%n", tokId);
                continue;
            }
            if (symbol.isTerminal()) {
                out.format("    public static final short TOKEN_%d = %d;%n", tokId, tokId);
                continue;
            }
            throw new Error("Can't generate parser with unnamed nonterminal!");
        }
        out.println();
        out.println("    public static final String[] NAMES = {");
        for (Symbol symbol : terminals) {
            int tokId = (Integer)sym2id.get(symbol);
            if (symbol.isNamed()) {
                out.format("        \"%s\",%n", symbol.name());
                continue;
            }
            if (symbol == Symbol.EOF) {
                out.format("        \"EOF\",%n", new Object[0]);
                continue;
            }
            if (symbol.isTerminal()) {
                out.format("        \"TOKEN_%d\",%n", tokId);
                continue;
            }
            throw new Error("Can't generate parser with unnamed nonterminal!");
        }
        out.println("    };");
        out.println("  }");
        out.println();
        out.println("  private final Action[] actions = {");
        HashMap<Reduce, Integer> hashMap5 = new HashMap<Reduce, Integer>();
        final HashMap<Reduce, Integer> hashMap6 = new HashMap<Reduce, Integer>();
        int actionId = 0;
        HashMap<Tuple<Symbol, Integer>, Integer> returnAction = new HashMap<Tuple<Symbol, Integer>, Integer>();
        HashSet<Integer> extraReturns = new HashSet<Integer>();
        try (TraceEvent ignored = trace.event("actions");){
            for (ItemSet set : itemSets) {
                Map<Symbol, Action> setActions = transitions.actions.get(set);
                for (Symbol tok : terminals) {
                    Reduce reduce;
                    Action act = setActions.get(tok);
                    if (!(act instanceof Reduce) || hashMap5.containsKey(reduce = (Reduce)act)) continue;
                    int ruleId = actionId;
                    if (reduce.rule.action.isEmpty()) {
                        Tuple<Symbol, Integer> key = Tuple.of(reduce.rule.lhs, reduce.rule.rhs.size());
                        Integer matchedId = (Integer)returnAction.get(key);
                        if (matchedId != null) {
                            hashMap5.put(reduce, matchedId);
                            continue;
                        }
                        returnAction.put(key, actionId);
                        hashMap6.put(reduce, actionId);
                        hashMap5.put(reduce, actionId);
                        ++actionId;
                        int num = reduce.rule.rhs.size();
                        switch (num) {
                            case 0: {
                                out.format("    Action.NONE, // [%d] %s (default action: return null)%n", ruleId, reduce.rule.shortDesc());
                                break;
                            }
                            case 1: {
                                out.format("    Action.RETURN, // [%d] %s (default action: return symbol 1)%n", ruleId, reduce.rule.shortDesc());
                                break;
                            }
                            default: {
                                out.format("    RETURN%d, // [%d] %s (default action: return symbol %d)%n", num, ruleId, reduce.rule.shortDesc(), num);
                                extraReturns.add(num);
                            }
                        }
                        continue;
                    }
                    hashMap6.put(reduce, actionId);
                    hashMap5.put(reduce, actionId);
                    ++actionId;
                    out.format("    new Action() { // [%d] %s%n", ruleId, reduce.rule.shortDesc());
                    out.println("      public Symbol reduce(Symbol[] _symbols, int offset) {");
                    List<Symbol> rhs = reduce.rule.rhs;
                    for (int id2 = 0; id2 < rhs.size(); ++id2) {
                        String symType = Grammar.typeOf(rhs.get(id2), this.rules);
                        out.format("        final %s ", symType);
                        if (reduce.rule.names.isEmpty()) {
                            Symbol sym = rhs.get(id2);
                            if (!sym.isTerminal()) {
                                out.print(sym.name());
                            } else if (sym.isNamed()) {
                                out.print(sym.name());
                            } else {
                                out.format("sym%d", id2 + 1);
                            }
                        } else {
                            out.print(reduce.rule.names.get(id2));
                        }
                        if (symType.equals("Symbol")) {
                            out.format(" = _symbols[offset + %d];%n", id2 + 1);
                            continue;
                        }
                        out.format(" = (%s) _symbols[offset + %d].value;%n", symType, id2 + 1);
                    }
                    out.format("        %s%n", reduce.rule.action);
                    out.println("      }");
                    out.println("    },");
                }
            }
        }
        out.println("  };");
        for (Integer num : extraReturns) {
            out.println();
            out.format("      static final Action RETURN%d = new Action() {%n", num);
            out.println("        public Symbol reduce(Symbol[] _symbols, int offset) {");
            out.format("          return _symbols[offset + %d];%n", num);
            out.println("        }");
            out.format("      };", new Object[0]);
        }
        int numterm = terminals.size();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(bos);
        DataOutputStream dout = new DataOutputStream(deflater);
        HashMap<Integer, Integer> actionTable = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> lookaheads = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> defaultActions = new HashMap<Integer, Integer>();
        HashSet<Integer> usedOffsets = new HashSet<Integer>();
        ArrayList<ItemSet> sortedItems = new ArrayList<ItemSet>(itemSets);
        Collections.sort(sortedItems, new Comparator<ItemSet>(){

            @Override
            public int compare(ItemSet o1, ItemSet o2) {
                return Integer.compare(o1.id(), o2.id());
            }
        });
        HashMap<Integer, Map<Integer, Integer>> acts = new HashMap<Integer, Map<Integer, Integer>>();
        for (ItemSet set : itemSets) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            Map<Symbol, Action> setActions = transitions.actions.get(set);
            Tuple range2 = (Tuple)hashMap3.get(set);
            if (range2 != null) {
                int min = (Integer)range2.first;
                int max = (Integer)range2.second;
                for (int id3 = min; id3 <= max; ++id3) {
                    Action action = (Action)setActions.get(hashMap.get(id3));
                    if (action instanceof Reduce) {
                        Reduce reduce = (Reduce)action;
                        map.put(id3, -((Integer)hashMap5.get(reduce)).intValue() - 1);
                        continue;
                    }
                    if (!(action instanceof Shift)) continue;
                    Shift shift = (Shift)action;
                    map.put(id3, shift.next.id());
                }
            }
            acts.put(set.id(), map);
        }
        HashMap<Integer, Map<Integer, Integer>> gotos = new HashMap<Integer, Map<Integer, Integer>>();
        boolean errorAct = false;
        int acceptAct = -hashMap6.size() - 1;
        for (ItemSet set : itemSets) {
            Map<Symbol, ItemSet> trans = transitions.map.get(set);
            Map<Symbol, Action> setActions = transitions.actions.get(set);
            HashMap map = new HashMap();
            for (Symbol sym : nonterminals) {
                ItemSet next = trans.get(sym);
                if (next != null) {
                    map.put(sym2id.get(sym), next.id());
                    continue;
                }
                Action action = setActions.get(sym);
                if (action != Action.ACCEPT) continue;
                map.put(sym2id.get(sym), acceptAct);
            }
            gotos.put(set.id(), map);
        }
        HashMap<Integer, Integer> actionOffsets = new HashMap<Integer, Integer>();
        try (TraceEvent ignored = trace.event("action table");){
            int actOffset = 0;
            for (ItemSet set : sortedItems) {
                range = (Tuple)hashMap3.get(set);
                if (range != null) {
                    int min = (Integer)range.first;
                    int max = (Integer)range.second;
                    actions = ((Map)acts.get(set.id())).values();
                    if (Grammar.allSame(actions)) {
                        Integer firstAction = actions.iterator().next();
                        defaultActions.put(set.id(), firstAction);
                        actionOffsets.put(set.id(), Integer.MIN_VALUE);
                        continue;
                    }
                    boolean placed = false;
                    int offset = actOffset;
                    actOffset += terminals.size();
                    while (!placed) {
                        for (int setId = 1; !placed && setId < set.id(); ++setId) {
                            if (acts.get(setId) != acts.get(set.id())) continue;
                            placed = true;
                            actionOffsets.put(set.id(), (Integer)actionOffsets.get(setId));
                        }
                        if (!actionTable.containsKey(offset) && (placed = this.tryPlaceActions(actionTable, lookaheads, acts, set, offset, min, max))) {
                            actionOffsets.put(set.id(), offset - min);
                        }
                        if (placed) continue;
                        ++offset;
                    }
                    continue;
                }
                actionOffsets.put(set.id(), Integer.MIN_VALUE);
            }
        }
        HashMap<Integer, Integer> gotoOffsets = new HashMap<Integer, Integer>();
        try (TraceEvent ignored = trace.event("goto table");){
            for (ItemSet set : sortedItems) {
                range = (Tuple)hashMap4.get(set);
                if (range != null) {
                    int min = (Integer)range.first;
                    int max = (Integer)range.second;
                    actions = ((Map)gotos.get(set.id())).values();
                    if (!defaultActions.containsKey(set.id()) && Grammar.allSame(actions)) {
                        if (actions.isEmpty()) {
                            System.err.format("err set: %s (%d, %d)", set, min, max);
                            System.err.println("gotos: " + hashMap2.get(set));
                            System.err.println("actions:");
                            System.err.println(transitions.actions.get(set));
                            for (Action act : transitions.actions.get(set).values()) {
                                System.out.println(act);
                            }
                            for (Symbol sym : transitions.actions.get(set).keySet()) {
                                if (sym.isTerminal()) continue;
                                System.err.println("  " + sym2id.get(sym));
                                System.err.println("  -> " + transitions.actions.get(set).get(sym));
                            }
                            System.err.println("transitions:");
                            for (ItemSet next : transitions.map.get(set).values()) {
                                System.out.println(next);
                            }
                            for (Symbol sym : transitions.map.get(set).keySet()) {
                                if (sym.isTerminal()) continue;
                                System.err.println("  " + sym2id.get(sym));
                            }
                        }
                        Integer firstAction = actions.iterator().next();
                        defaultActions.put(set.id(), firstAction);
                        gotoOffsets.put(set.id(), Integer.MIN_VALUE);
                        continue;
                    }
                    boolean placed = false;
                    for (int setId = 1; !placed && setId < set.id(); ++setId) {
                        if (gotos.get(setId) != gotos.get(set.id())) continue;
                        placed = true;
                        gotoOffsets.put(set.id(), (Integer)gotoOffsets.get(setId));
                    }
                    int offset = 0;
                    while (!placed) {
                        if (!placed && !actionTable.containsKey(offset) && (placed = this.tryPlaceGotos(actionTable, lookaheads, usedOffsets, gotos, set, offset, min, max))) {
                            gotoOffsets.put(set.id(), offset - min);
                        }
                        if (placed) continue;
                        ++offset;
                    }
                    continue;
                }
                gotoOffsets.put(set.id(), Integer.MAX_VALUE);
            }
        }
        int numActions = (Integer)Grammar.range(actionTable.keySet()).second + 1;
        dout.writeInt(numActions);
        for (index = 0; index < numActions; ++index) {
            Integer act = (Integer)actionTable.get(index);
            if (act != null) {
                dout.writeShort(act);
                continue;
            }
            dout.writeShort(0);
        }
        for (index = 0; index < numActions; ++index) {
            Integer sym = (Integer)lookaheads.get(index);
            if (sym != null) {
                dout.writeShort(sym);
                continue;
            }
            dout.writeShort(-1);
        }
        dout.writeInt(itemSets.size() + 1);
        dout.writeInt(Integer.MIN_VALUE);
        for (id = 1; id <= itemSets.size(); ++id) {
            dout.writeInt((Integer)actionOffsets.get(id));
        }
        dout.writeInt(Integer.MIN_VALUE);
        for (id = 1; id <= itemSets.size(); ++id) {
            dout.writeInt((Integer)gotoOffsets.get(id));
        }
        dout.writeInt(itemSets.size() + 1);
        dout.writeShort(0);
        for (id = 1; id <= itemSets.size(); ++id) {
            Integer act = (Integer)defaultActions.get(id);
            if (act != null) {
                dout.writeShort(act);
                continue;
            }
            dout.writeShort(0);
        }
        dout.writeInt(hashMap6.keySet().size());
        ArrayList sortedActions = new ArrayList(hashMap6.keySet());
        Collections.sort(sortedActions, new Comparator<Reduce>(){

            @Override
            public int compare(Reduce o1, Reduce o2) {
                return Integer.compare((Integer)hashMap6.get(o1), (Integer)hashMap6.get(o2));
            }
        });
        for (Reduce reduce : sortedActions) {
            int act = -((Integer)hashMap6.get(reduce)).intValue() - 1;
            int info = (Integer)sym2id.get(reduce.rule.lhs) << 16 | reduce.rule.rhs.size();
            dout.writeInt(info);
        }
        dout.writeShort(terminals.size() + nonterminals.size());
        dout.close();
        deflater.close();
        out.println();
        out.println("  static final ParsingTables PARSING_TABLES = new ParsingTables(");
        String tables = Util.base64Encode(bos.toByteArray());
        for (int offset = 0; offset < tables.length(); offset += 71) {
            if (offset > 0) {
                out.println(" +");
            }
            String part = tables.substring(offset);
            part = part.substring(0, Math.min(part.length(), 71));
            out.format("    \"%s\"", part);
        }
        out.println(");");
        out.println();
        out.format("  public %s() {%n", this.className);
        out.println("    super(PARSING_TABLES);");
        out.println("  }");
        out.println();
        out.println("  protected Symbol invokeReduceAction(int rule_num, int offset) {");
        out.println("    return actions[rule_num].reduce(_symbols, offset);");
        out.println("  }");
        out.println("}");
    }

    boolean tryPlaceActions(Map<Integer, Integer> actionTable, Map<Integer, Integer> lookaheads, Map<Integer, Map<Integer, Integer>> acts, ItemSet set, int offset, int min, int max) {
        int index;
        int id;
        Map<Integer, Integer> map = acts.get(set.id());
        for (id = min + 1; id <= max; ++id) {
            index = offset + id - min;
            if (!map.containsKey(id) || !actionTable.containsKey(index)) continue;
            return false;
        }
        for (id = min; id <= max; ++id) {
            index = offset + id - min;
            Integer act = map.get(id);
            if (act == null) continue;
            actionTable.put(index, act);
            lookaheads.put(index, id);
        }
        return true;
    }

    boolean tryPlaceGotos(Map<Integer, Integer> actionTable, Map<Integer, Integer> lookaheads, Set<Integer> usedOffsets, Map<Integer, Map<Integer, Integer>> gotos, ItemSet set, int offset, int min, int max) {
        int index;
        int id;
        if (usedOffsets.contains(offset - min)) {
            return false;
        }
        Map<Integer, Integer> map = gotos.get(set.id());
        for (id = min + 1; id <= max; ++id) {
            index = offset + id - min;
            if (!map.containsKey(id) || !actionTable.containsKey(index)) continue;
            return false;
        }
        for (id = min; id <= max; ++id) {
            index = offset + id - min;
            Integer act = map.get(id);
            if (act == null) continue;
            actionTable.put(index, act);
            lookaheads.put(index, id);
        }
        usedOffsets.add(offset - min);
        return true;
    }

    public void checkProblems(ProblemHandler problems, Set<Symbol> roots) {
        StringBuilder sb;
        HashSet<Symbol> terminals = new HashSet<Symbol>();
        for (Symbol sym : this.syms) {
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            roots.add(sym);
        }
        for (Rule rule : this.rules) {
            for (Symbol sym : rule.rhs) {
                if (sym.isTerminal()) {
                    terminals.remove(sym);
                    continue;
                }
                roots.remove(sym);
            }
        }
        roots.remove(Symbol.GOAL);
        if (!roots.isEmpty()) {
            sb = new StringBuilder();
            sb.append("found unused nonterminal(s):");
            for (Symbol root : roots) {
                sb.append(String.format("%n  %s was declared at %s", root, root.pos()));
            }
            problems.warn(sb.toString());
        }
        terminals.remove(Symbol.EOF);
        if (!terminals.isEmpty()) {
            sb = new StringBuilder();
            sb.append("found unused terminal(s):");
            for (Symbol term : terminals) {
                sb.append(String.format("%n  %s was declared at %s", term, term.pos()));
            }
            problems.warn(sb.toString());
        }
    }

    public Symbol sym(int index) {
        return this.symIndex.get(index);
    }

    public String precedenceTerminal(Action action) {
        if (action instanceof Shift) {
            return ((Shift)action).sym.name();
        }
        if (action instanceof Reduce) {
            Rule rule = ((Reduce)action).rule;
            if (!rule.precedence.isEmpty()) {
                return rule.precedence;
            }
            for (int i = rule.rhs.size() - 1; i >= 0; --i) {
                Symbol sym = rule.rhs.get(i);
                if (!sym.isTerminal() || !this.precedence.containsKey(sym.name())) continue;
                return sym.name();
            }
        }
        return "?term";
    }
}

