/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Action;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.Reduce;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.SymSet;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple;
import org.extendj.neobeaver.Tuple3;
import org.extendj.neobeaver.Util;

public class Item {
    public final Rule rule;
    public final int dot;
    private final Item next;
    public final Set<Symbol> follow = new HashSet<Symbol>();
    public List<Item> succ = new LinkedList<Item>();
    private Collection<Item> extension = null;

    public Item(Rule rule, int dot, Symbol ... follows) {
        this.rule = rule;
        this.dot = dot;
        for (Symbol sym : follows) {
            this.follow.add(sym);
        }
        if (dot < rule.rhs.size()) {
            this.next = new Item(rule, dot + 1, follows);
            this.succ.add(this.next);
        } else {
            this.next = null;
        }
    }

    public void addFollow(Symbol sym) {
        this.follow.add(sym);
    }

    public void addFollows(Collection<Symbol> sym) {
        this.follow.addAll(sym);
    }

    private SymSet lookaheads(Grammar grammar) {
        SymSet set = new SymSet(grammar);
        for (int i = this.dot + 1; i < this.rule.rhs.size(); ++i) {
            Symbol x = this.rule.rhs.get(i);
            set.or(grammar.first(x));
            if (grammar.nullable(x)) continue;
            return set;
        }
        set.addAll(this.follow);
        return set;
    }

    public void addToFollowSet(Map<Symbol, Tuple<Symbol, ItemSet>> map) {
        if (this.canAdvance()) {
            Symbol sym = this.afterDot();
            Item item = this.advance();
            Tuple<Symbol, ItemSet> set = map.get(sym);
            if (set == null) {
                set = Tuple.of(sym, new ItemSet(-1));
                map.put(sym, set);
            }
            ((ItemSet)set.second).items.put(item, item);
        }
    }

    public Collection<Item> immediateExtension(Grammar grammar) {
        if (this.extension != null) {
            return this.extension;
        }
        this.extension = new HashSet<Item>();
        if (this.dot < this.rule.rhs.size()) {
            Symbol afterDot = this.rule.rhs.get(this.dot);
            boolean nullableItem = this.nullableAfter(this.dot + 1, grammar);
            SymSet lookahead = this.lookaheads(grammar);
            for (Rule rule : grammar.byLhs.get(afterDot)) {
                Item item = new Item(rule, 0, new Symbol[0]);
                for (Symbol sym : lookahead) {
                    item.follow.add(sym);
                }
                this.extension.add(item);
                if (!nullableItem) continue;
                this.succ.add(item);
            }
        }
        return this.extension;
    }

    public boolean nullable(Grammar grammar) {
        return this.nullableAfter(0, grammar);
    }

    public boolean nullableAfter(int pos, Grammar grammar) {
        for (int i = pos; i < this.rule.rhs.size(); ++i) {
            Symbol sym = this.rule.rhs.get(i);
            if (!sym.isTerminal() && grammar.nullable(sym)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.rule.lhs + " =");
        for (int i = 0; i < this.rule.rhs.size(); ++i) {
            if (i == this.dot) {
                buf.append(" .");
            }
            buf.append(" ").append(this.rule.rhs.get(i));
        }
        if (this.dot == this.rule.rhs.size()) {
            buf.append(" .");
        }
        if (!this.follow.isEmpty()) {
            boolean first = true;
            ArrayList<String> follows = new ArrayList<String>(this.follow.size());
            for (Symbol sym : this.follow) {
                follows.add(Util.escape(sym.toString()));
            }
            Collections.sort(follows);
            buf.append(" [");
            buf.append(String.join((CharSequence)", ", follows));
            buf.append("]");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.rule.hashCode() ^ this.dot;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Item) {
            Item other = (Item)obj;
            return this.dot == other.dot && this.rule.equals(other.rule);
        }
        return false;
    }

    public boolean canAdvance() {
        return this.next != null;
    }

    public Symbol afterDot() {
        return this.rule.rhs.get(this.dot);
    }

    public Item advance() {
        if (this.next == null) {
            throw new Error("Cannot advance dot past end of item.");
        }
        return this.next;
    }

    public Item baseItem() {
        return this;
    }

    public Collection<Tuple3<ItemSet, Symbol, Action>> reduceActions(Grammar grammar, ItemSet set) {
        ArrayList<Tuple3<ItemSet, Symbol, Action>> actions = new ArrayList<Tuple3<ItemSet, Symbol, Action>>();
        for (Symbol sym : this.follow) {
            actions.add(Tuple.of(set, sym, new Reduce(this.rule)));
        }
        return actions;
    }

    public Collection<Symbol> followSyms() {
        return this.follow;
    }

    public boolean related(Symbol sym) {
        return this.dot == this.rule.rhs.size() && this.follow.contains(sym);
    }
}

