/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple;
import org.extendj.neobeaver.Util;
import se.llbit.util.CollectionComparison;

public class ItemSet {
    private final int id;
    public final Map<Item, Item> items;
    public final Map<Item, Item> extension;
    public final ItemSet core;
    private ItemSet baseCore = null;

    public ItemSet(int id) {
        this(id, new HashSet<Item>());
    }

    public ItemSet(int id, Set<Item> items) {
        this.id = id;
        this.items = new HashMap<Item, Item>();
        for (Item it : items) {
            this.items.put(it, it);
        }
        this.extension = new HashMap<Item, Item>();
        this.core = this;
    }

    public ItemSet(int id, ItemSet core, Collection<Item> extension) {
        this.id = id;
        this.items = core.items;
        this.extension = new HashMap<Item, Item>();
        for (Item it : extension) {
            this.extension.put(it, it);
        }
        this.core = core;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("item set S%d%n", this.id));
        buf.append(this.setToString("  ", this.items));
        buf.append(this.setToString("+ ", this.extension));
        return buf.toString();
    }

    private String setToString(String prefix, Map<Item, Item> set) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Item item : set.values()) {
            lines.add(String.format("%s%s%n", prefix, Util.escape(item.toString())));
        }
        Collections.sort(lines);
        StringBuilder buf = new StringBuilder();
        for (String line : lines) {
            buf.append(line);
        }
        return buf.toString();
    }

    public Map<Symbol, Tuple<Symbol, ItemSet>> followCores() {
        HashMap<Symbol, Tuple<Symbol, ItemSet>> follows = new HashMap<Symbol, Tuple<Symbol, ItemSet>>();
        for (Item item : this.items.values()) {
            item.addToFollowSet(follows);
        }
        for (Item item : this.extension.values()) {
            item.addToFollowSet(follows);
        }
        return follows;
    }

    public int hashCode() {
        int hash = 0;
        for (Item item : this.items.values()) {
            hash ^= item.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemSet) {
            ItemSet other = (ItemSet)obj;
            return CollectionComparison.isEqualCollection(this.items.values(), other.items.values());
        }
        return false;
    }

    public ItemSet core() {
        return this.core;
    }

    public void printGraphNode() {
        System.out.format("  S%d[label=\"\\N\\n", this.id());
        ItemSet.printDotSet("  ", this.items.values());
        ItemSet.printDotSet("+ ", this.extension.values());
        System.out.println("\"];");
    }

    private static void printDotSet(String prefix, Iterable<Item> set) {
        ArrayList<String> items = new ArrayList<String>();
        for (Item item : set) {
            items.add(String.format("%s%s\\l", prefix, Util.escape(item.toString())));
        }
        Collections.sort(items);
        for (String string : items) {
            System.out.print(string);
        }
    }

    public ItemSet baseCore() {
        if (this.baseCore == null) {
            HashSet<Item> baseItems = new HashSet<Item>();
            for (Item item : this.items.values()) {
                baseItems.add(item.baseItem());
            }
            this.baseCore = new ItemSet(-1, baseItems);
        }
        return this.baseCore;
    }

    public Collection<Item> relatedItems(Symbol sym) {
        ArrayList<Item> result = new ArrayList<Item>();
        ArrayList advanced = new ArrayList();
        for (Item item : this.items.values()) {
            if (!item.related(sym)) continue;
            result.add(item);
        }
        for (Item item : this.extension.values()) {
            if (!item.related(sym)) continue;
            result.add(item);
        }
        return result;
    }
}

