/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.recaptcha;

import org.loom.addons.recaptcha.RecaptchaService;
import org.loom.interceptor.PopulateInterceptor;
import org.loom.mapping.ParsedAction;
import org.loom.resolution.Resolution;
import org.loom.servlet.LoomServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecaptchaInterceptor
implements PopulateInterceptor {
    @Autowired
    private RecaptchaService service;

    public Resolution beforePopulate(ParsedAction action) {
        LoomServletRequest request = action.getRequest();
        String challenge = request.getStringParameter("recaptcha_challenge_field");
        String response = request.getStringParameter("recaptcha_response_field");
        request.getRequestParameters().setAssigned("recaptcha_challenge_field");
        request.getRequestParameters().setAssigned("recaptcha_response_field");
        String messageKey = this.service.validate(request.getRemoteAddr(), challenge, response);
        if (messageKey != null) {
            request.setAttribute("recaptcha-message", (Object)messageKey);
            request.getParsedAction().getMessages().error("captcha.error.incorrect");
        }
        return null;
    }

    public void setCaptchaService(RecaptchaService captchaService) {
        this.service = captchaService;
    }
}

