/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.recaptcha;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.LoomServletRequestImpl;
import org.loom.tags.JspWriterWrapper;
import org.loom.url.UrlBuilder;
import org.tldgen.annotations.Attribute;
import org.tldgen.annotations.BodyContent;
import org.tldgen.annotations.Tag;

@Tag(bodyContent=BodyContent.EMPTY, example="&lt;recaptcha publicKey=\"my-public-key\"/>")
public class RecaptchaTag
extends SimpleTagSupport {
    public static final String RECAPTCHA_ERROR_MESSAGE = "recaptcha-message";
    public static final String CHALLENGE_PARAM = "recaptcha_challenge_field";
    public static final String RESPONSE_PARAM = "recaptcha_response_field";
    public static final String HTTP_SERVER = "api.recaptcha.net";
    public static final String HTTPS_SERVER = "api-secure.recaptcha.net";
    @Attribute
    private boolean noscript = true;
    @Attribute(required=true)
    private String publicKey;

    public void doTag() throws JspException, IOException {
        LoomServletRequest request = LoomServletRequestImpl.getThreadLocal();
        UrlBuilder url = request.createUrl();
        if (request.isSecure()) {
            url.setScheme(UrlBuilder.SECURE_SCHEME);
            url.setHostname(HTTPS_SERVER);
        } else {
            url.setScheme(UrlBuilder.INSECURE_SCHEME);
            url.setHostname(HTTP_SERVER);
        }
        url.setRawUrl("/challenge");
        url.addParameter("k", (Object)this.publicKey);
        url.addParameter("error", request.getAttribute(RECAPTCHA_ERROR_MESSAGE));
        JspWriterWrapper out = new JspWriterWrapper(this.getJspContext().getOut());
        out.start("script", new Object[]{"src", url.getURL()}).end("script");
        if (this.noscript) {
            out.start("noscript", new Object[0]);
            url.setRawUrl("/noscript");
            out.start("iframe", new Object[]{"src", url.getURL(), "height", 300, "width", 500, "frameborder", 0});
            out.end("iframe");
            out.start("textarea", new Object[]{"name", CHALLENGE_PARAM, "rows", 3, "cols", 40}).end("textarea");
            out.startEnd("input", new Object[]{"name", RESPONSE_PARAM, "type", "hidden", "value", "manual_challenge"});
            out.end("noscript");
        }
    }

    public void setNoscript(boolean noscript) {
        this.noscript = noscript;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }
}

