/**
 * 
 *
 * @author ggarcia
 * @author icoloma
 */
S2.UI.MultiAutocompleter = Class.create({

	initialize: function(input, options) {
		this.options = Object.extend({
			allowNewChoices: false // true to allow data not present as autocompleter choices
		}, options || {});
		this.values = $A([]);
		this.hidden = $(input);
		this.hidden.hide();
		var li = new Element('li');
		var ul = this.ul = new Element('ul', { className: 'mautocomp' }).update(li);
		this.hidden.insert({ after: ul });
		
		/** create and tweak autocompleter */
		this.autocompleter = new S2.UI.Autocompleter(li, this.options);
		this.autocompleter.findChoices = this.findChoices.bind(this);
		var menu = this.autocompleter.menu;
		ul.insert({ after: menu });
		this.resizeMenu();
		this.input = li.down('input');

		ul.observe('keypress', this.onKeyPress.bindAsEventListener(this));
		ul.observe('click', this.onClick.bindAsEventListener(this));
		menu.element.observe('ui:menu:selected', this.addValue.bind(this));
		this.initValues(this.hidden.getValue());
		
		var form = input.up('form');
		form && form.observe('submit', this.onSubmit.bindAsEventListener(this));
	},
	
	/**
	 * Override the autocompleter findChoices method to avoid repeating what has already been added
	 * This is the default scripty2 implementation, plus an extra check
	 */
    findChoices: function() {
      var value = this.input.getValue().toLowerCase();
      var choices = this.autocompleter.choices || [];
      var va = this.values;
      var results = choices.select(function(choice) {
        return choice.toLowerCase().include(value) && !va.include(choice);
      });
      this.autocompleter.setChoices(results);
    },
    
    resizeMenu: function() {
	    var layout = this.ul.getLayout();
	    this.autocompleter.menu.element.setStyle({
		  left: layout.get('left') + 'px',
		  top:  (layout.get('top') + layout.get('margin-box-height')) + 'px'
		});
    },
	
	/**
	 * Convert the current values to li tags
	 */
	initValues: function(text) {
	   	var addValue = this.addValue.bind(this);
	   	
	   	// introduce quoted values
		//text = text.gsub(/"[^"]+"/, function(match) { addValue(match[0].gsub('"','').strip()); }); 
		
		// introduce the rest (space-separated values)
		$w(text).each(addValue);
	},
	
	/**
	 * text: the text to add. If omitted, this.input.getValue() will be used
	 */
	addValue: function(data) {
		var text = (data.eventName && this.input.getValue()) || data;
		if (!text.blank() && !this.values.include(text)) {
			this.values.push(text);
			this.ul.down('li:last-child()').insert({ 
				before: '<li class="item">#{text}<a href="#" class="remove"/></li>'.interpolate( { text: text } ) 
			});
			this.updateHidden();
			this.input.setValue('');
			
			// to execute after the event has been processed
			data.eventName && function() { this.input.focus(); }.bind(this).delay();
			//data.eventName && window.setTimeout(0, function() { this.input.focus() }.bind(this) });
		}
	},
	
	updateHidden: function() {
		this.hidden.setValue(this.values.join(' '));
		this.resizeMenu();
	},
	
	onClick: function(e) {
		var a = e.findElement('a.remove');
		if (a) {
			e.stop();
			this.removeItem(a.up('li'));
		} else {
			this.input.focus();
		}
		this.ul.select('li.focused').invoke('removeClassName', 'focused');
	},
	
	removeItem: function(li) {
		li.down('a').remove();
		this.values = this.values.without(li.innerHTML);
		li.remove();
		this.updateHidden();
	},
    
	onKeyPress: function(e) {
		var keyCode = e.keyCode || e.which;
		if (keyCode == Event.KEY_BACKSPACE && !this.input.getValue()) {
			li = this.ul.select('li.item').last();
			li && this.removeItem(li);
		} else if (keyCode == Event.KEY_RETURN && this.input.getValue() && this.options.allowNewChoices) {
			this.addValue({ eventName: 'addNewValue' });
			e.stop();
		}
	},
	
	/**
	 * Triggered when the user clicks the submit button.
	 * If the user input field is not empty, either clean it up or accept it depending of the value of 
	 * this.options.allowNewChoices
	 */
	onSubmit: function() {
		if (this.input.getValue()) {
			if (this.options.allowNewChoices) {
				this.addValue({ eventName: 'addNewValue' });
			} else {
				this.input.setValue('');
			}
		}
	}
    
});

