/**
 * Creates an Autocompleter.Local or Ajax.Autocompleter depending on the field attributes
 * @param options the list of options that will be propagated to the created autocompleter
 * @return the created instance
 */
loom.ui.createAutocompleter = function(element, options) {
	
    element = $(element);
    var choicesDisplay = $('choices');
    if (choicesDisplay == null) {
      $(document.body).insert('<div id="choices" style="display:none"> </div>');
      choicesDisplay = $('choices');
    }
    
    var choices = element.id && window[element.id + '_options'];
    if (choices) { 
      return new Autocompleter.Local(element, choicesDisplay, choices, options);
    } else { 
      new Ajax.Autocompleter(element, choicesDisplay, element.getExtendedAttribute('autocompleter-url'), options);
    } 
    
}