/**
 * Confirmation before following a link or submitting a form.
 */
loom.ui.Confirmation = Class.create({

  initialize: function(element) {
    this.element = element;
    this.confirmationId = element.getExtendedAttribute('confirmation-id');
    this.message = element.getExtendedAttribute('confirmation-message', this.confirmationId);
  },
    
  // intercepts the click event over a link or button element
  onClick: function(event) {
    event.stop();
    this.openWindow();
  },
  
  // intercepts the click over a confirmation button (accept or cancel)
  onConfirmationClick: function(e) {
    var a = e.findElement('a');
    if (a != null) {
      e.stop();
      this.closeWindow();
      if (a.hasClassName('accept')) 
        this.onAccept(e);
    }
  },
  
  /**
   * Override to use a different window system
   * message: the window message
   * onAccept: the handler if the user clicks accept
   */
  openWindow: function() {
    if (!$('confirmationBuffer'))
      $(document.body).insert('<div id="confirmationBuffer" style="display:none"></div>');
  
    var html = ('#{message}' +
    '<div id="confirmation-buttons"><a href="#" class="accept">#{accept}</a><a href="#" class="cancel">#{cancel}</a>' +
    '</div>').interpolate({
      message: loom.messages[this.message + '.message'],
      accept: loom.messages[this.message + '.accept'],
      cancel: loom.messages[this.message + '.cancel']
    });
    var c = this;
    Modalbox.show(html, { 
      title: loom.messages[this.message + '.title'], 
      afterLoad: function() { 
		    $('confirmation-buttons').observe('click', c.onConfirmationClick.bindAsEventListener(c));
      }
    });
    
  },
  
  /**
   * Override to use a different window system
   */
  closeWindow: function() {
    Modalbox.hide();
  }
  
});

Object.extend(loom.ui, {

	LinkConfirmation: Class.create(loom.ui.Confirmation, {
	
    initialize: function($super, a) {
      $super(a);
      this.targetUrl = a.href + (a.href.include('?') ? '&' : '?') + loom.PARAM_PREFIX + "confirmation-" + this.confirmationId + "=true";
    },
    
    onAccept: function(e) {
      window.location.href = this.targetUrl;
    }
    
	}),
	
	FormConfirmation: Class.create(loom.ui.Confirmation, {
	
    onAccept: function(e) {
      var button = this.element;
      var form = button.up('form');
      form.insert(new Element("input", { name: loom.PARAM_PREFIX + "confirmation-" + this.confirmationId, value: 'true', type: 'hidden' }));

      this.closeWindow();
      if (button.name.startsWith(loom.PARAM_PREFIX + 'event-')) { // overriden event
        element = new Element("input", { name: button.name, value: 'true', type: 'hidden' });
        element.identify();
        form.insert(element);
        this.submit(form);
        element.remove();
      } else {
        this.submit(form);
      }
    },
    
    // this method is here just for testcases
    submit: function(form) {
      form.submit();
    }
    
 	}),
 	
 	bindConfirmations: function(element) {
    if (Object.isArray(element)) {
      element.each(loom.ui.bindConfirmations);
      return;
    } 
    var c;
    if (element.tagName == 'A') {
      c = new loom.ui.LinkConfirmation(element);
    } else if (element.match('input[type=submit]')) {
      c = new loom.ui.FormConfirmation(element);
    } else  {
      throw new Error('Unable to handle element ' + element);
 	}
    element.observe('click', c.onClick.bindAsEventListener(c));
    }
	
});
