/**
 * Creates a slider under a container to change its height
 * 
 * Events: 
 * resizable:resize when the user is resizing the object. If this event gets stopped(), the resize will not happen.
 * resizable:startResize when the user starts resizing.
 * resizable:endResize when the user ends resizing.
 * 
 * @author rgrocha
 * @author icoloma
 */
loom.ui.Resizable = Class.create({

	initialize : function(element, options) {

		this.element = $(element);
		this.options = Object.extend({
			// minHeight: null the minimum allowed height, in pixels
			// maxHeight: null the maximum allowed height, in pixels
            opacity: .25 // the opacity to use while dragging
		}, options || {})
		var c = Element.wrap(this.element, 'div', { className: 'resizable' });
		this.container = c;
		this.grippie = new Element('div', { className: 'grippie' });
		c.insert(this.grippie);

		this.startDrag = this.startDrag.bindAsEventListener(this);
		this.performDrag = this.performDrag.bindAsEventListener(this);
		this.endDrag = this.endDrag.bindAsEventListener(this);
		
		var min = this.options.minHeight;
		min && this.element.getHeight() < min && this.setHeight(min);

		this.grippie.observe('mousedown', this.startDrag);
	},
	
	observe: function(eventName, listener) {
		this.element.observe(eventName, listener);
	},

	startDrag : function (e) {
		e.stop();
		this.staticOffset = this.element.getHeight() - Event.pointerY(e);
		this.element.setStyle({opacity : this.options.opacity});
		this.element.fire('resizable:startResize');

		document.observe('mousemove', this.performDrag);
		document.observe('mouseup', this.endDrag);
	},

	performDrag : function (e) {
		e.stop();
		var height = Math.max(32, this.staticOffset + Event.pointerY(e));
		var event = this.element.fire('resizable:resize', { height: height });
		if (event.stopped || this.options.minHeight && this.options.minHeight > height || this.options.maxHeight && this.options.maxHeight < height) {
			return;
		}
		this.setHeight(height);
	},
	
	setHeight: function(height) {
		this.element.setStyle({'height' : height + 'px'});
	},

	endDrag : function (e) {
		document.stopObserving('mousemove', this.performDrag);
		document.stopObserving('mouseup', this.endDrag);
		this.element.setStyle({opacity : 1});
		this.element.fire('resizable:endResize');
	}
    
});

loom.ui.ResizableTextArea = loom.ui.Resizable;
