/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.autocompleter;

import javax.persistence.NoResultException;

import org.loom.i18n.Messages;
import org.loom.i18n.MessagesRepository;
import org.loom.util.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Retrieves a JPA instance from the database according to an autocompleter user input.
 * This interceptor can handle single property (mortgage.name).
 * 
 * @author icoloma
 */
@Component
@Scope(BeanDefinition.SCOPE_PROTOTYPE)
public class AutocompletedConverter extends AbstractAutocompletedConverter {

	public Object getAsObject(String paramName, String paramValue, Messages messages, MessagesRepository repository) {
		if (!StringUtils.isEmpty(paramValue)) { // if "", set as null
			try {
				return retrieveEntity(paramValue);
			} catch (NoResultException e) {
				addErrorMessage(messages, paramName, paramValue, "persistence.autocompletedEntityNotFound");
			}
		}
		return null;
	}

	public String getAsText(Object value, MessagesRepository repository) {
		if (value == null) {
			return null;
		}
		Object result = getPropertyWrapper().get(value, false);
		return result == null? null : result.toString();
	}

}
