/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.confirmation;

import java.security.Principal;

import org.loom.log.Log;
import org.loom.servlet.LoomServletRequest;

/**
 * Just logs the result of the confirmation
 * @author icoloma
 */
public class DefaultConfirmationLogger implements ConfirmationLogger {

	private static Log log = Log.getLog(DefaultConfirmationLogger.class);
	
	public void logAccepts(LoomServletRequest request, ConfirmationType type, String id) {
		String userName = extractUserName(request);
		log.debug("User ", userName, " has accepted ", type, ": ", id);
	}

	private String extractUserName(LoomServletRequest request) {
		Principal principal = request.getUserPrincipal();
		String userName = principal == null? "<unauthenticated>" : principal.getName();
		return userName;
	}

	public void logRejects(LoomServletRequest request, ConfirmationType type, String id) {
		String userName = extractUserName(request);
		log.debug("User ", userName, " has rejected ", type, ": ", id);
	}

	
	
}
