/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.multiupload;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotate persistent file collections to receive multiple files at once, 
 * merging with the contents of the actual collection.
 * 
 * @author Ignacio Coloma
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.METHOD})
@Documented
public @interface MultiUpload {

	/** maximum file size allowed */
	long maxFileSize() default -1;
	
	/** minimum number of files */
	int minFilesCount() default -1;
	
	/** maximum number of files */
	int maxFilesCount() default -1;
	
	/** expected file name pattern */
    String filenameMaskPattern() default "";
	
    /** if provided, applies to the property path instead of the annotated property */
    String propertyPath() default "";

    /** the list of events to apply, empty for all. Accepts wildcards. */
    String[] on() default {};
    
    /** the list of events to NOT apply, empty for none. Accepts wildcards. */
    String[] except() default {};

}
