package org.loom.addons.recaptcha;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks an event to validate using the ReCaptcha service. If the user
 * does not introduce the correct text displayed in the captcha, a validation
 * error will occur.
 *  
 * @author Ignacio Coloma
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface Recaptcha {

}
