package org.loom.addons.recaptcha;

import org.loom.annotation.processor.AbstractInjectedAnnotationProcessor;
import org.loom.mapping.Event;
import org.springframework.stereotype.Component;

/**
 * Processes {@link Recaptcha} annotations
 * 
 * @author icoloma
 *
 */
@Component
public class RecaptchaAnnotationProcessor extends AbstractInjectedAnnotationProcessor<RecaptchaInterceptor> {

	public RecaptchaAnnotationProcessor() {
		super(RecaptchaInterceptor.class);
	}
	
	@Override
	public void process(Event event) {
		Recaptcha annotation = event.getJavaMethod().getAnnotation(Recaptcha.class);
		if (annotation != null) {
			event.addInterceptor(getInstance());
		}
	}

}
