package org.loom.addons.recaptcha;

import org.loom.interceptor.PopulateInterceptor;
import org.loom.mapping.ParsedAction;
import org.loom.resolution.Resolution;
import org.loom.servlet.LoomServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Validates the Captcha. Queries the ReCaptcha service and adds a validation error message if 
 * the captcha value is not correct. 
 * 
 * @author icoloma
 */
@Component
public class RecaptchaInterceptor implements PopulateInterceptor {

	@Autowired
	private RecaptchaService service;
	
	public Resolution beforePopulate(ParsedAction action) {
		LoomServletRequest request = action.getRequest();
		String challenge = request.getStringParameter(RecaptchaTag.CHALLENGE_PARAM);
		String response = request.getStringParameter(RecaptchaTag.RESPONSE_PARAM);
		request.getRequestParameters().setAssigned(RecaptchaTag.CHALLENGE_PARAM);
		request.getRequestParameters().setAssigned(RecaptchaTag.RESPONSE_PARAM);
		
		String messageKey = service.validate(request.getRemoteAddr(), challenge, response);
		if (messageKey != null) {
			request.setAttribute(RecaptchaTag.RECAPTCHA_ERROR_MESSAGE, messageKey);
			request.getParsedAction().getMessages().error("captcha.error.incorrect");
		}
		return null;
	}
	
	public void setCaptchaService(RecaptchaService captchaService) {
		this.service = captchaService;
	}
	
}
