package org.loom.addons.recaptcha;

public interface RecaptchaService {

	/**
	 * Check a response introduced by the user to a ReCaptcha challenge
	 * @param remoteAddr the user IP address
	 * @param challenge the challenge ID provided by ReCaptcha to the user
	 * @param response the response introduced by the user
	 * @return null if the user response is correct, else return the ReCaptcha error code.
	 */
	public String validate(String remoteAddr, String challenge, String response);

}
