/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.multiupload;

import java.util.regex.Pattern;
import org.loom.addons.multiupload.MultiUpload;
import org.loom.addons.multiupload.MultiUploadInterceptor;
import org.loom.annotation.processor.AbstractPropertyAnnotationProcessor;
import org.loom.interceptor.Interceptor;
import org.loom.mapping.Event;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MultiUploadAnnotationProcessor
extends AbstractPropertyAnnotationProcessor<MultiUpload, MultiUpload> {
    @Autowired
    private ApplicationContext applicationContext;

    public MultiUploadAnnotationProcessor() {
        super(MultiUpload.class, null);
    }

    protected void process(Event event, MultiUpload annotation, String propertyPath) {
        MultiUploadInterceptor interceptor = this.getInstance();
        if (annotation.maxFileSize() != -1L) {
            interceptor.setMaxFileSize(annotation.maxFileSize());
        }
        if (annotation.minFilesCount() != -1) {
            interceptor.setMinFilesCount(annotation.minFilesCount());
        }
        if (annotation.maxFilesCount() != -1) {
            interceptor.setMaxFilesCount(annotation.maxFilesCount());
        }
        if (annotation.filenameMaskPattern().length() > 0) {
            Pattern p = Pattern.compile(annotation.filenameMaskPattern(), 2);
            interceptor.setFilenameMaskPattern(p);
        }
        interceptor.setPropertyPath(propertyPath);
        event.addInterceptor((Interceptor)interceptor);
    }

    protected MultiUploadInterceptor getInstance() {
        return (MultiUploadInterceptor)BeanFactoryUtils.beanOfType((ListableBeanFactory)this.applicationContext, MultiUploadInterceptor.class);
    }
}

