/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.multiupload;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.loom.addons.multiupload.MultiUploadInterceptor;
import org.loom.i18n.Message;
import org.loom.interceptor.AbstractPropertyBoundInterceptor;
import org.loom.log.Log;
import org.loom.mapping.ParsedAction;
import org.loom.persistence.file.FileManager;
import org.loom.persistence.file.PersistentFile;
import org.loom.resolution.Resolution;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.params.FileParameter;
import org.loom.servlet.params.ServletRequestParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class MultiuploadInterceptorImpl
extends AbstractPropertyBoundInterceptor
implements MultiUploadInterceptor {
    @Autowired
    private FileManager fileManager;
    private Long maxFileSize;
    private Integer minFilesCount;
    private Integer maxFilesCount;
    private Pattern filenameMaskPattern;
    private boolean deleteRemovedFiles = true;
    private static Log log = Log.getLog(MultiuploadInterceptorImpl.class);

    public Resolution beforeValidate(ParsedAction action) {
        String propertyPath = this.getPropertyPath();
        LoomServletRequest request = action.getRequest();
        ServletRequestParameters requestParameters = request.getRequestParameters();
        HashMap uploadedFiles = Maps.newHashMap();
        HashSet keptFiles = Sets.newHashSet();
        for (Map.Entry entry : requestParameters.getFileParametersEntrySet()) {
            String paramName = (String)entry.getKey();
            if (!paramName.startsWith(propertyPath)) continue;
            FileParameter value = (FileParameter)entry.getValue();
            uploadedFiles.put(paramName, value);
            requestParameters.setAssigned(paramName);
            if (this.maxFileSize != null && value.getFileSize() > this.maxFileSize) {
                this.addErrorMessage(action, "loom.validation.fileSizeTooLarge", value);
                continue;
            }
            if (this.filenameMaskPattern == null || this.filenameMaskPattern.matcher(value.getFilename()).matches()) continue;
            this.addErrorMessage(action, "loom.validation.fileNameFailed", value);
        }
        for (Map.Entry entry : requestParameters.getStringParametersEntrySet()) {
            if (!((String)entry.getKey()).startsWith("_uploaded-")) continue;
            keptFiles.add(entry.getValue());
        }
        request.setAttribute("_uploadedFiles", (Object)uploadedFiles);
        request.setAttribute("_keptFiles", (Object)keptFiles);
        int size = keptFiles.size() + uploadedFiles.size();
        if (this.minFilesCount != null && this.minFilesCount > size) {
            this.addErrorMessage(action, "multiupload.validation.minFilesFailed", null);
        }
        if (this.maxFilesCount != null && this.maxFilesCount < size) {
            this.addErrorMessage(action, "multiupload.validation.maxFilesFailed", null);
        }
        return null;
    }

    @Transactional
    public Resolution beforeExecute(ParsedAction action) {
        String propertyPath = this.getPropertyPath();
        LoomServletRequest request = action.getRequest();
        Map uploadedFiles = (Map)request.getAttribute("_uploadedFiles");
        Set keptFiles = (Set)request.getAttribute("_keptFiles");
        ArrayList<PersistentFile> files = (ArrayList<PersistentFile>)action.getPropertyAsObject(propertyPath);
        if (files == null) {
            files = new ArrayList<PersistentFile>();
            action.setPropertyAsObject(propertyPath, files);
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            PersistentFile file = (PersistentFile)i.next();
            if (file == null || file.getId() == null || keptFiles.contains(file.getId().toString())) continue;
            log.trace(new Object[]{"Removing persistent file with id=", file.getId(), " because it was not included in the current request"});
            i.remove();
            if (!this.deleteRemovedFiles) continue;
            this.fileManager.remove(file.getId());
        }
        if (!action.hasAnyError()) {
            for (FileParameter uploadedFile : uploadedFiles.values()) {
                log.debug(new Object[]{"Saving uploaded file to database ", uploadedFile.getFilename()});
                files.add(this.fileManager.merge(uploadedFile));
            }
        }
        return null;
    }

    public void addErrorMessage(ParsedAction action, String messageKey, FileParameter value) {
        Message message = new Message(messageKey);
        message.addArg("value", (Object)value);
        message.addArg("interceptor", (Object)this);
        message.addTranslatedArg("propertyName", (Object)this.getPropertyPath());
        action.getMessages().addMessage(message);
    }

    public void setFileManager(FileManager fileController) {
        this.fileManager = fileController;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setFilenameMaskPattern(Pattern filenameMaskPattern) {
        this.filenameMaskPattern = filenameMaskPattern;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public Pattern getFilenameMaskPattern() {
        return this.filenameMaskPattern;
    }

    public Integer getMinFilesCount() {
        return this.minFilesCount;
    }

    public void setMinFilesCount(Integer minFilesCount) {
        this.minFilesCount = minFilesCount;
    }

    public Integer getMaxFilesCount() {
        return this.maxFilesCount;
    }

    public void setMaxFilesCount(Integer maxFilesCount) {
        this.maxFilesCount = maxFilesCount;
    }

    public boolean isDeleteRemovedFiles() {
        return this.deleteRemovedFiles;
    }

    public void setDeleteRemovedFiles(boolean deleteRemovedFiles) {
        this.deleteRemovedFiles = deleteRemovedFiles;
    }
}

