/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.recaptcha;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.loom.addons.recaptcha.AbstractRecaptchaService;
import org.loom.log.Log;
import org.loom.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRecaptchaServiceImpl
extends AbstractRecaptchaService {
    private String proxyHost;
    private Integer proxyPort;
    private static Log log = Log.getLog(DefaultRecaptchaServiceImpl.class);

    @Override
    protected byte[] getValidationResult(Map<String, String> params) {
        try {
            HttpPost post = this.createPostRequest(params);
            HttpClient client = this.createHttpClient();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            client.execute((HttpUriRequest)post).getEntity().writeTo((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpClient createHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        if (!StringUtils.isEmpty((String)this.proxyHost)) {
            log.debug(new Object[]{"Executing request via proxy: ", this.proxyHost});
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort.intValue());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        return client;
    }

    protected HttpPost createPostRequest(Map<String, String> params) throws URISyntaxException, UnsupportedEncodingException {
        HttpPost post = new HttpPost(VERIFY_URL.toURI());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        return post;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }
}

