/*  Window.Growl, version 2.0: http://icebeat.bitacoras.com
 *  Daniel Mota aka IceBeat <daniel.mota@gmail.com>
 *  
 *  Mod for usage with Prototype/Script.aculo.us by silvanji <silvan@liip.ch>
 *  Mod to use CSS classes and prototype 1.6.0.3 by Ignacio Coloma
 *  
 *  Usage: 
 *  	Growl.bezel('Message');
 *  	Growl.smoke('Message');
 *  	Growl.smoke({ title: "Warning", text: 'Message', duplicatesAllowed: true); 
 *  Appearance can be tuned by modifying growl.css
--------------------------------------------------------------------------*/
var Gr0wl = {

	// queue of Growl instances
    queue: {
        smoke: $A(),
        bezel: $A()
    }

};

Gr0wl.Base = Class.create({
	
    show: function(options) {
	    
        options = Object.extend({
        	title: 'Information', // title of the dialog
            text: 'Put some body text', // text of the message
        	duration: 2.5, // duration to display the message
        	duplicatesAllowed: false // false to drop duplicate messages
        }, options || {});
        this.options = options;
        
        if (!options.duplicatesAllowed && 
        		Gr0wl.queue[this.queueID].find(function(e) { 
        			return e.options.title == options.title && e.options.text == options.text})
        			) {
        	// message already present, skip
        	return;
        }

        var body = $(document.body);
        body.insert('<div class="#{css}" style="display:none"><h3>#{title}</h3><p>#{text}</p></div>'.interpolate(options));
        this.element = body.immediateDescendants().last();
        this.position();
        this.push();
		
        var fxOpts = { to: .9, queue: options.queue };
        this.element.appear(fxOpts);
        this.hide();
        
    },

    /** push this instance in the corresponding Growl queue */
    push: function() {
      Gr0wl.queue[this.queueID].push(this);
    },

    /** remove this instance from the corresponding Growl queue */
    pop: function() {
      Gr0wl.queue[this.queueID].shift();
    },

    /** peek at the last instance from the corresponding Growl queue */
    last: function() {
      return Gr0wl.queue[this.queueID].last();
    },
	
	hide: function(options) {
        return new Effect.Opacity(this.element, Object.extend({
            delay: this.options.duration,
        	from: 0.9,
            to: 0.0,
            duration: 0.5,
            afterFinish: function(o) {
                o.element.remove();
                this.pop();
            }.bind(this)
           }, options || {})
        );
    },
	
	getScrollTop: function() {
    	return document.viewport.getScrollOffsets()[1];
	},
    
    getScrollLeft: function() {
		return document.viewport.getScrollOffsets()[0];
    }
	
});


Gr0wl.Smoke = Class.create(Gr0wl.Base, {

    queueID: 'smoke',

	show: function($super, options) {
		options = Object.extend(options, {
            css: (options.css || '') + 'growl smoke',
            queue: 'parallel'
        }); 
		$super(options);
	},

	hide: function($super, options) {
		options = Object.extend({ queue: 'parallel' }, options || {});
		$super(options);
	},

	/**
	 * Position the new element below the last message
	 */
    position: function() {
		var last = this.last();
        var delta = (last && last.element.cumulativeOffset().top + last.element.getHeight() + 5) || this.getScrollTop();
        this.element.setStyle( { top: delta + 'px' } );
    }
	
});

Gr0wl.Bezel = Class.create(Gr0wl.Base, {
	
    queueID: 'bezel',

	show: function($super, options) {
        options = Object.extend(options, {
            css: (options.css || '') + 'growl bezel',
            queue: 'end'
        });
        $super(options);
    },
	
	hide: function($super) {
        new Effect.Parallel([
            $super({ sync: true}),
            new Effect.Move(this.element, { y: 50, sync: true })
        ], { delay: this.options.duration, duration: 0.5, queue: 'end' });
	},

	/**
	 * Position the new element centered
	 */
    position: function() {
		var top = this.getScrollTop() + (document.viewport.getHeight() - this.element.getHeight()) / 2;
		var left = this.getScrollLeft() + (document.viewport.getWidth() - this.element.getWidth()) / 2;
        this.element.setStyle( { 'top': top + 'px', 'left': left + 'px' } );
    }

});

var Growl =  {
	
	bezel: function(options) {
		new Gr0wl.Bezel().show(Object.isString(options)? { text: options} : options || {});
	},
	smoke: function(options) {
		new Gr0wl.Smoke().show(Object.isString(options)? { text: options} : options || {});
	}
};


