/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.autocompleter;

import javax.inject.Inject;
import javax.persistence.PersistenceContext;

import org.loom.binding.AnnotationContainer;
import org.loom.binding.PropertyWrapperFactory;
import org.loom.converter.AnnotationDrivenConverterFactory;
import org.loom.converter.Converter;
import org.loom.persistence.ExtendedEntityManager;

public class AutocompletedConverterFactory implements AnnotationDrivenConverterFactory<Autocompleted> {

	@PersistenceContext
	private ExtendedEntityManager entityManager;

	@Inject
	private PropertyWrapperFactory propertyWrapperFactory;

	public Converter getConverter(AnnotationContainer propertyWrapper, Autocompleted annotation) {
		
		AbstractAutocompletedConverter converter;
		Class<?> persistentClass;
		
		if (annotation.separatorTokens().length() > 0) {
			converter = new MultipleAutocompletedConverter();
			((MultipleAutocompletedConverter)converter).setSeparatorTokens(annotation.separatorTokens());
			int length = propertyWrapper.getItemMetadataSize();
			persistentClass = length == 0? propertyWrapper.getPropertyClass() : propertyWrapper.getItemMetadata(length - 1).getItemClass();
		} else {
			converter = new AutocompletedConverter();
			persistentClass = propertyWrapper.getPropertyClass();
		}
		converter.setPersistentClass(persistentClass);
		converter.setPropertyName(annotation.propertyName());
		converter.setEntityManager(entityManager);
		converter.setConvertedClass(propertyWrapper.getPropertyClass());
		if (annotation.query().length() > 0) {
			converter.setQuery(annotation.query());
		}
		converter.setPropertyWrapper(propertyWrapperFactory.createInstance(persistentClass, annotation.propertyName()));
		return converter;
	}

	public Class<Autocompleted> getAnnotationClass() {
		return Autocompleted.class;
	}

	public void setEntityManager(ExtendedEntityManager entityManager) {
		this.entityManager = entityManager;
	}

	public void setPropertyWrapperFactory( PropertyWrapperFactory propertyWrapperFactory) {
		this.propertyWrapperFactory = propertyWrapperFactory;
	}

}
