/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.multiupload;

import java.util.regex.Pattern;

import javax.inject.Inject;

import org.loom.annotation.processor.AbstractPropertyAnnotationProcessor;
import org.loom.mapping.Event;
import org.loom.persistence.file.FileManager;


/**
 * Processes {@link MultiUpload} annotations
 * @author icoloma
 *
 */
public class MultiUploadAnnotationProcessor extends AbstractPropertyAnnotationProcessor<MultiUpload, MultiUpload> {

	@Inject
	private FileManager fileManager;

	public MultiUploadAnnotationProcessor() {
		super(MultiUpload.class, null);
	}
	
	@Override
	protected void process(Event event, MultiUpload annotation, String propertyPath) {
		MultiuploadInterceptorImpl interceptor = new MultiuploadInterceptorImpl();
		interceptor.setFileManager(fileManager);
		if (annotation.maxFileSize() != -1) {
			interceptor.setMaxFileSize(annotation.maxFileSize());
		}
		if (annotation.minFilesCount() != -1) {
			interceptor.setMinFilesCount(annotation.minFilesCount());
		}
		if (annotation.maxFilesCount() != -1) {
			interceptor.setMaxFilesCount(annotation.maxFilesCount());
		}
		if (annotation.filenameMaskPattern().length() > 0) {
			Pattern p = Pattern.compile(annotation.filenameMaskPattern(), Pattern.CASE_INSENSITIVE);
			interceptor.setFilenameMaskPattern(p);
		}
		interceptor.setPropertyPath(propertyPath);
		event.addInterceptor(interceptor);
	}
	
}
