/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.multiupload;

import org.loom.interceptor.ExecuteInterceptor;
import org.loom.interceptor.ValidateInterceptor;

/**
 * Store and merge the files uploaded in this form submission.
 * Uploaded files that do not pass the configured validations (size and file name)
 * are not accepted.
 * 
 * Note that this interceptor does not remove orphan files from the underlying storage. It 
 * is responsibility of the application developer to do so using cleanup threads or similar. 
 * @author Ignacio Coloma
 */

public interface MultiUploadInterceptor extends ValidateInterceptor, ExecuteInterceptor {
	
}
