package org.loom.addons.recaptcha;

import javax.inject.Inject;

import org.loom.annotation.processor.AbstractAnnotationProcessor;
import org.loom.mapping.Event;

/**
 * Processes {@link Recaptcha} annotations
 * 
 * @author icoloma
 *
 */
public class RecaptchaAnnotationProcessor extends AbstractAnnotationProcessor {

	@Inject
	private RecaptchaService service;
	
	private RecaptchaInterceptor interceptor;

	@Override
	public void process(Event event) {
		Recaptcha annotation = event.getJavaMethod().getAnnotation(Recaptcha.class);
		if (annotation != null) {
			event.addInterceptor(interceptor);
		}
	}

	public void setService(RecaptchaService service) {
		this.service = service;
		this.interceptor = new RecaptchaInterceptor();
		this.interceptor.setRecaptchaService(this.service);
	}
	
}
