/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.autocompleter;

import javax.persistence.NoResultException;
import org.loom.binding.PropertyWrapper;
import org.loom.converter.AbstractConverter;
import org.loom.persistence.ExtendedEntityManager;
import org.loom.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutocompletedConverter
extends AbstractConverter {
    private String query;
    private Class<?> persistentClass;
    private String propertyName;
    private ExtendedEntityManager entityManager;
    private PropertyWrapper propertyWrapper;

    protected AbstractAutocompletedConverter() {
        super(Object.class);
    }

    private void updateQuery() {
        if (this.persistentClass != null && this.propertyName != null && this.query == null) {
            this.query = "select o from " + this.persistentClass.getName() + " o where o." + this.propertyName + "=?";
        }
    }

    protected Object retrieveEntity(String propertyValue) throws NoResultException {
        return this.entityManager.findSingle(this.query, new Object[]{propertyValue});
    }

    public void setPersistentClass(Class<?> persistentClass) {
        if (ClassUtils.isAbstract(persistentClass)) {
            throw new IllegalArgumentException(persistentClass.getName() + " cannot be used for @Autocompleted because it is abstract");
        }
        this.persistentClass = persistentClass;
        this.updateQuery();
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.updateQuery();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Class<?> getPersistentClass() {
        return this.persistentClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setEntityManager(ExtendedEntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setPropertyWrapper(PropertyWrapper propertyWrapper) {
        this.propertyWrapper = propertyWrapper;
    }

    public PropertyWrapper getPropertyWrapper() {
        return this.propertyWrapper;
    }
}

