/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.autocompleter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import org.loom.addons.autocompleter.AbstractAutocompletedConverter;
import org.loom.addons.autocompleter.MultipleAutocompletedConverter;
import org.loom.binding.PropertyWrapper;
import org.loom.converter.Converter;
import org.loom.tags.core.InputTextTag;
import org.loom.url.ParameterContainer;
import org.loom.url.UrlBuilder;
import org.loom.util.HtmlSanitizer;
import org.tldgen.annotations.Attribute;
import org.tldgen.annotations.BodyContent;
import org.tldgen.annotations.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Tag(dynamicAttributes=true, bodyContent=BodyContent.SCRIPTLESS, example="&lt;a:autocompleter action=\"MyAction\" event=\"myevent\" name=\"mortgage.name\">\n   &lt;l:param name=\"param1\" value=\"value1\">\n&lt;/a:autocompleter>")
public class AutocompleterTag
extends InputTextTag
implements ParameterContainer {
    static String AUTOCOMPLETER_URL = "autocompleter-url";
    static String AUTOCOMPLETER_SEPARATOR_TOKENS = "autocompleter-separator-tokens";
    private UrlBuilder url = new UrlBuilder();
    @Attribute
    private List<?> options;

    public AutocompleterTag() {
        this.setCssClass("autocompleter");
    }

    public void doTagImpl() throws JspException, IOException {
        if (!this.url.isEmpty()) {
            this.setExtendedAttribute(AUTOCOMPLETER_URL, this.url.getURL(this.request));
        } else if (this.options != null) {
            this.identify();
            Converter c = this.getForm().getTargetAction().getConverter(this.getNormalizedName());
            if (c != null && c instanceof MultipleAutocompletedConverter) {
                MultipleAutocompletedConverter converter = (MultipleAutocompletedConverter)c;
                this.setExtendedAttribute(AUTOCOMPLETER_SEPARATOR_TOKENS, converter.getSeparatorTokens());
            }
            this.printAutocompleterOptions(c);
        } else {
            throw new IllegalArgumentException("Either an options list or an action/event pair must be provided");
        }
        super.doTagImpl();
    }

    protected void printAutocompleterOptions(Converter converter) throws IOException {
        StringBuilder arrayAsString = new StringBuilder();
        arrayAsString.append("[ ");
        PropertyWrapper property = null;
        if (converter != null && converter instanceof AbstractAutocompletedConverter) {
            property = ((AbstractAutocompletedConverter)converter).getPropertyWrapper();
        }
        Iterator<?> i = this.options.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (property != null) {
                value = property.get(value, false);
            }
            String sv = value == null ? null : value.toString();
            arrayAsString.append('\"').append(HtmlSanitizer.sanitize((String)sv)).append('\"');
            if (!i.hasNext()) continue;
            arrayAsString.append(", ");
        }
        arrayAsString.append(" ]");
        this.out.startJavascript();
        this.out.print((CharSequence)"var ").print((CharSequence)this.getId()).print((CharSequence)"_options = ").print((CharSequence)arrayAsString).print((CharSequence)";\n");
        this.out.endJavascript();
    }

    @Attribute
    public void setUrl(String url) {
        this.url.setRawUrl(url);
    }

    public AutocompleterTag addParameter(String name, Object value) {
        this.url.addParameter(name, value);
        return this;
    }

    @Attribute
    public void setAction(String action) {
        this.url.setAction(action);
    }

    @Attribute
    public void setEvent(String event) {
        this.url.setEvent(event);
    }

    public void setOptions(List<?> options) {
        this.options = options;
    }
}

