/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.autocompleter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.NoResultException;
import org.apache.commons.lang.StringUtils;
import org.loom.addons.autocompleter.AbstractAutocompletedConverter;
import org.loom.i18n.Messages;
import org.loom.i18n.MessagesRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAutocompletedConverter
extends AbstractAutocompletedConverter {
    private String separatorTokens;

    public Object getAsObject(String paramName, String paramValue, Messages messages, MessagesRepository repository) {
        int i = 0;
        Collection<?> result = this.createCollection();
        ArrayList<String> wrongValues = new ArrayList<String>();
        if (paramValue != null && paramValue.length() > 0) {
            for (String fragment : StringUtils.split((String)paramValue, (String)this.separatorTokens)) {
                try {
                    result.add(this.retrieveEntity(fragment));
                }
                catch (NoResultException e) {
                    wrongValues.add(fragment);
                }
                ++i;
            }
        }
        if (wrongValues.isEmpty()) {
            return result;
        }
        messages.error(paramName, "persistence.multipleAutocompletedEntityNotFound").addArg("wrongValues", wrongValues);
        return null;
    }

    private Collection<?> createCollection() {
        return Set.class.isAssignableFrom(this.getConvertedClass()) ? new LinkedHashSet() : new ArrayList();
    }

    public String getAsText(Object value, MessagesRepository repository) {
        if (value == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator i = ((Iterable)value).iterator();
        while (i.hasNext()) {
            buffer.append(this.getPropertyWrapper().get(i.next(), false));
            if (!i.hasNext()) continue;
            buffer.append(this.separatorTokens.charAt(0));
        }
        return buffer.toString();
    }

    public void setSeparatorTokens(String tokenSeparators) {
        this.separatorTokens = tokenSeparators;
    }

    public String getSeparatorTokens() {
        return this.separatorTokens;
    }
}

