/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.confirmation;

import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.loom.addons.confirmation.ConfirmationInterceptor;
import org.loom.addons.confirmation.ConfirmationLogger;
import org.loom.addons.confirmation.DefaultConfirmationLogger;
import org.loom.addons.confirmation.RequiresConfirmation;
import org.loom.annotation.processor.AbstractAnnotationProcessor;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.interceptor.Interceptor;
import org.loom.mapping.Event;

public class RequiresConfirmationAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Inject
    private MessagesRepositoryFactory messagesRepositoryFactory;
    private ConfirmationLogger confirmationLogger = new DefaultConfirmationLogger();

    public void process(Event event) {
        RequiresConfirmation annotation = event.getJavaMethod().getAnnotation(RequiresConfirmation.class);
        if (annotation != null) {
            ConfirmationInterceptor interceptor = new ConfirmationInterceptor();
            interceptor.setConfirmationLogger(this.confirmationLogger);
            interceptor.setId(annotation.id());
            interceptor.setType(annotation.type());
            String message = annotation.message();
            if (!StringUtils.isEmpty((String)message)) {
                interceptor.setMessage(message);
            } else {
                message = annotation.id();
            }
            event.addInterceptor((Interceptor)interceptor);
            this.messagesRepositoryFactory.addBrowserMessage(message + ".title");
            this.messagesRepositoryFactory.addBrowserMessage(message + ".message");
            this.messagesRepositoryFactory.addBrowserMessage(message + ".accept");
            this.messagesRepositoryFactory.addBrowserMessage(message + ".cancel");
        }
    }

    public void setMessagesRepositoryFactory(MessagesRepositoryFactory messagesRepositoryFactory) {
        this.messagesRepositoryFactory = messagesRepositoryFactory;
    }

    public void setConfirmationLogger(ConfirmationLogger confirmationLogger) {
        this.confirmationLogger = confirmationLogger;
    }
}

