/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.recaptcha;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.loom.addons.recaptcha.RecaptchaService;
import org.loom.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecaptchaService
implements RecaptchaService {
    public static final URL VERIFY_URL;
    private String privateKey;

    @Override
    public String validate(String remoteAddr, String challenge, String response) {
        try {
            if (StringUtils.isEmpty((String)challenge) || StringUtils.isEmpty((String)response)) {
                return "incorrect-captcha-sol";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("privatekey", this.privateKey);
            params.put("remoteip", remoteAddr);
            params.put("challenge", challenge);
            params.put("response", response);
            byte[] c = this.getValidationResult(params);
            if (c == null || c.length == 0) {
                return "ReCaptcha server returned an empty response";
            }
            String[] contents = StringUtils.split((String)new String(c, "UTF-8"), (char)'\n');
            return "true".equals(contents[0]) ? null : contents[1];
        }
        catch (IOException e) {
            return "recaptcha-not-reachable";
        }
    }

    protected abstract byte[] getValidationResult(Map<String, String> var1);

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    static {
        try {
            VERIFY_URL = new URL("http://api-verify.recaptcha.net/verify");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

