/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.recaptcha;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.jsp.JspException;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.tags.AbstractTag;
import org.loom.tags.functions.Functions;
import org.loom.url.UrlBuilder;
import org.tldgen.annotations.Attribute;
import org.tldgen.annotations.BodyContent;
import org.tldgen.annotations.Tag;

@Tag(bodyContent=BodyContent.EMPTY, example="&lt;recaptcha publicKey=\"my-public-key\"/>")
public class RecaptchaTag
extends AbstractTag {
    public static final String RECAPTCHA_ERROR_MESSAGE = "recaptcha-message";
    public static final String CHALLENGE_PARAM = "recaptcha_challenge_field";
    public static final String RESPONSE_PARAM = "recaptcha_response_field";
    public static final String HTTP_SERVER = "api.recaptcha.net";
    public static final String HTTPS_SERVER = "api-secure.recaptcha.net";
    @Attribute
    private boolean noscript = true;
    @Attribute(required=true)
    private String publicKey;
    private Map<String, Object> options = Maps.newHashMap();
    private static final Set<String> SUPPORTED_LANGUAGES = Sets.newHashSet((Object[])new String[]{"en", "nl", "fr", "de", "pt", "ru", "es", "tr"});
    private static final Set<String> SUPPORTED_THEMES = Sets.newHashSet((Object[])new String[]{"red", "white", "blackglass", "clean", "custom"});
    @Inject
    private MessagesRepositoryFactory messagesRepositoryFactory;

    public void doTagImpl() throws JspException, IOException {
        UrlBuilder url = this.request.createUrl();
        if (this.request.isSecure()) {
            url.setScheme(UrlBuilder.SECURE_SCHEME);
            url.setHostname(HTTPS_SERVER);
        } else {
            url.setScheme(UrlBuilder.INSECURE_SCHEME);
            url.setHostname(HTTP_SERVER);
        }
        url.setRawUrl("/challenge");
        url.add("k", (Object)this.publicKey);
        url.add("error", this.request.getAttribute(RECAPTCHA_ERROR_MESSAGE));
        if (!this.options.isEmpty()) {
            this.out.start("script", new Object[0]);
            this.out.print((CharSequence)"var RecaptchaOptions=").print((CharSequence)Functions.json(this.options)).print((CharSequence)";");
            this.out.end("script");
        }
        this.out.start("script", new Object[]{"src", url.getURL()}).end("script");
        if (this.noscript) {
            this.out.start("noscript", new Object[0]);
            url.setRawUrl("/noscript");
            this.out.start("iframe", new Object[]{"src", url.getURL(), "height", 300, "width", 500, "frameborder", 0});
            this.out.end("iframe");
            this.out.start("textarea", new Object[]{"name", CHALLENGE_PARAM, "rows", 3, "cols", 40}).end("textarea");
            this.out.startEnd("input", new Object[]{"name", RESPONSE_PARAM, "type", "hidden", "value", "manual_challenge"});
            this.out.end("noscript");
        }
    }

    public void setNoscript(boolean noscript) {
        this.noscript = noscript;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Attribute
    public void setTheme(String theme) {
        if (!SUPPORTED_THEMES.contains(theme)) {
            throw new IllegalArgumentException("Theme not supported: " + theme + ". Available themes are: " + SUPPORTED_THEMES);
        }
        this.options.put("theme", theme);
    }

    @Attribute
    public void setLang(String lang) {
        if (!SUPPORTED_LANGUAGES.contains(lang)) {
            lang = this.messagesRepositoryFactory.getDefaultLocale().getLanguage();
        }
        this.options.put("lang", lang);
    }

    @Attribute
    public void setCustomThemeWidget(String customThemeWidget) {
        this.options.put("custom_theme_widget", customThemeWidget);
    }

    @Attribute
    public void setTabIndex(int tabIndex) {
        this.options.put("tabindex", tabIndex);
    }
}

