/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.autocompleter;

import org.loom.binding.PropertyWrapper;
import org.loom.config.Config;
import org.loom.converter.Converter;
import org.loom.converter.SimpleConverterFactory;
import org.loom.exception.ConfigException;
import org.loom.injection.DependencyInjectionAdapter;

public class AutocompletedConverterFactory implements SimpleConverterFactory {

	public Converter getConverter(PropertyWrapper propertyWrapper) {
		Autocompleted annotation = propertyWrapper.getAnnotation(Autocompleted.class);
		if (annotation == null) {
			return null;
		}
		
		AbstractAutocompletedConverter converter;
		
		if (annotation.separatorTokens().length() > 0) {
			converter = createConverter(MultipleAutocompletedConverter.class);
			((MultipleAutocompletedConverter)converter).setSeparatorTokens(annotation.separatorTokens());
			converter.setPersistentClass(propertyWrapper.getNextPropertyClass());
		} else {
			converter = createConverter(AutocompletedConverter.class);
			converter.setPersistentClass(propertyWrapper.getPropertyClass());
		}
		
		converter.setConvertedClass(propertyWrapper.getPropertyClass());
		if (annotation.query().length() > 0) {
			converter.setQuery(annotation.query());
		}
		converter.setPropertyName(annotation.propertyName());
		converter.validate();
		return converter;
	}

	private AbstractAutocompletedConverter createConverter(Class<? extends AbstractAutocompletedConverter> clazz) {
		// lazy hack: we need some  more cases of Converter DI to be able to design something 
		// better...
		DependencyInjectionAdapter diAdapter = Config.getInstance().getDependencyInjectionAdapter();
		AbstractAutocompletedConverter converter = diAdapter.getBeanOfType(clazz);
		if (converter == null) {
			throw new ConfigException(clazz.getName() + " must be configured in " + diAdapter.getProviderName() + " to use @Autocompleted annotations");
		}
		return converter;
	}
	
}
