/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.tree;

import org.loom.i18n.MessagesRepository;
import org.loom.json.JsonMarshaller;


/**
 * Converts a tree node into a JSON representation. 
 * <p/>
 * NodeRenderer instances are NOT thread safe. 
 * @param <T> the tree node class 
 * @author icoloma
 */
public interface JsonNodeRenderer<T> {

	/**
	 * Convert the node attributes into JSON fields. If nestedLevel < maxDepth,
	 * it will also render its children nodes recursively. 
	 * @param nestedLevel the current nested level, starting at 0
	 * @param node the current node that should be converted to JSON 
	 */
	public JsonMarshaller renderNode(int nestedLevel, T node);

	public void setMessagesRepository(MessagesRepository repository);
	
	/**
	 * Set the maximum number of levels to be displayed.
	 * Set to -1 (the default) to visit all levels
	 */
	public void setMaxDepth(int max);
	
}
