/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.autocompleter;

import org.loom.addons.autocompleter.AbstractAutocompletedConverter;
import org.loom.addons.autocompleter.Autocompleted;
import org.loom.addons.autocompleter.AutocompletedConverter;
import org.loom.addons.autocompleter.MultipleAutocompletedConverter;
import org.loom.binding.PropertyWrapper;
import org.loom.config.Config;
import org.loom.converter.Converter;
import org.loom.converter.SimpleConverterFactory;
import org.loom.exception.ConfigException;
import org.loom.injection.DependencyInjectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutocompletedConverterFactory
implements SimpleConverterFactory {
    public Converter getConverter(PropertyWrapper propertyWrapper) {
        AbstractAutocompletedConverter converter;
        Autocompleted annotation = (Autocompleted)propertyWrapper.getAnnotation(Autocompleted.class);
        if (annotation == null) {
            return null;
        }
        if (annotation.separatorTokens().length() > 0) {
            converter = this.createConverter(MultipleAutocompletedConverter.class);
            ((MultipleAutocompletedConverter)converter).setSeparatorTokens(annotation.separatorTokens());
            converter.setPersistentClass(propertyWrapper.getNextPropertyClass());
        } else {
            converter = this.createConverter(AutocompletedConverter.class);
            converter.setPersistentClass(propertyWrapper.getPropertyClass());
        }
        converter.setConvertedClass(propertyWrapper.getPropertyClass());
        if (annotation.query().length() > 0) {
            converter.setQuery(annotation.query());
        }
        converter.setPropertyName(annotation.propertyName());
        converter.validate();
        return converter;
    }

    private AbstractAutocompletedConverter createConverter(Class<? extends AbstractAutocompletedConverter> clazz) {
        DependencyInjectionAdapter diAdapter = Config.getInstance().getDependencyInjectionAdapter();
        AbstractAutocompletedConverter converter = (AbstractAutocompletedConverter)((Object)diAdapter.getBeanOfType(clazz));
        if (converter == null) {
            throw new ConfigException(clazz.getName() + " must be configured in " + diAdapter.getProviderName() + " to use @Autocompleted annotations");
        }
        return converter;
    }
}

