/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.confirmation;

import org.apache.commons.lang.StringUtils;
import org.loom.addons.confirmation.ConfirmationInterceptor;
import org.loom.addons.confirmation.RequiresConfirmation;
import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.config.Config;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.interceptor.Interceptor;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.Event;

public class RequiresConfirmationAnnotationProcessor
extends AbstractInterceptorAnnotationProcessor {
    private MessagesRepositoryFactory messagesRepositoryFactory;

    public void configure(Config config) {
        super.configure(config);
        this.messagesRepositoryFactory = config.getMessagesRepositoryFactory();
    }

    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer methodWrapper : metadata.getAnnotatedMethods(new Class[]{RequiresConfirmation.class})) {
            RequiresConfirmation annotation = (RequiresConfirmation)methodWrapper.getAnnotation(RequiresConfirmation.class);
            Event event = mapping.getEvent(methodWrapper.getName());
            ConfirmationInterceptor interceptor = (ConfirmationInterceptor)this.getInterceptorFactory().newInstance(ConfirmationInterceptor.class);
            interceptor.setId(annotation.id());
            interceptor.setType(annotation.type());
            String message = annotation.message();
            if (!StringUtils.isEmpty((String)message)) {
                interceptor.setMessage(message);
            } else {
                message = annotation.id();
            }
            event.addInterceptor((Interceptor)interceptor);
            this.messagesRepositoryFactory.addJsonKey(message + ".title");
            this.messagesRepositoryFactory.addJsonKey(message + ".message");
            this.messagesRepositoryFactory.addJsonKey(message + ".accept");
            this.messagesRepositoryFactory.addJsonKey(message + ".cancel");
        }
    }

    public MessagesRepositoryFactory getMessagesRepositoryFactory() {
        return this.messagesRepositoryFactory;
    }

    public void setMessagesRepositoryFactory(MessagesRepositoryFactory messagesRepositoryFactory) {
        this.messagesRepositoryFactory = messagesRepositoryFactory;
    }
}

