/**
 * 
 *
 * @author ggarcia
 * @author icoloma
 */
loom.ui.InputList = Class.create({

	initialize: function(input, options) {
		this.hidden = $(input);

		this.hidden.hide();
		this.hidden.insert({ 
			after: '<input type="text" class="inputList"/><a href="#">#{add}</a>'.interpolate({
				add: loom.messages['loom.ui.add']
			}) 
		});
		var l = this.hidden.up('label') || this.hidden;
		l.insert({ after: new Element('ul', { className: "inputList", style: "display: none" }) });
		this.input = $(this.hidden.next('input'));
		this.btn = this.hidden.next('a');
		this.list = l.next('ul');
		this.input.observe('keypress', this.onKeyPress.bindAsEventListener(this));
		this.btn.observe('click', this.onClick.bindAsEventListener(this));
		this.list.observe('click', this.onRemove.bindAsEventListener(this));
		this.initializeValue(this.hidden.value);

        // put the hidden element after the label, if exists
		var label = this.input.up('label');
		label && label.insert({ after: this.hidden });
	},
	
	/**
	 * Convert the current values to li tags
	 */
	initializeValue: function(text) {
		this.list.update('');
	   	var replacement = text.gsub.prepareReplacement(this.insertOption.bind(this));
		var s = text.gsub(/"[^"]+"/, function(match) { replacement(match[0].gsub('"','').strip()); }); 
		$w(s).each(this.insertOption.bind(this));
	},
	
	insertOption: function(text) {
		if (!text.blank()) {
			var found = this.list.select('li span').findAll(function(e) { return e.innerHTML == text; });
			if (found.size() == 0) {
				this.list.insert(
					'<li><span>#{text}</span><a href="#" class="remove">#{remove}</a></li>'.interpolate(
					{ text: text, remove: loom.messages['loom.ui.remove'] }
				));
			}
			this.list.visible() || this.list.show();
		}
	},
	
	onRemove: function(e) {
		var btn = e.findElement('a.remove');
		if (btn) {
			e.stop();
			var li = btn.up('li');
			li.remove();

            var options = this.list.select('li span');
			this.hidden.value = options.map(function(e) {
				var value = e.innerHTML
				return (value.indexOf(' ') > -1 ? '"' + value + '"' : value);
			}).join(' ');
			
			// ie6 will not collapse the space occupied by an empty ul
			if (options.length == 0) this.list.hide();
		}
	},

	onClick: function(e) {
		e.stop();
		this.insert(this.input.value);
	},
    
	onKeyPress: function(e) {
		var keyCode = e.keyCode || e.which;
		if (keyCode == Event.KEY_RETURN) {
			e.stop();
			this.insert(this.input.value);
		}

	},
	
	insert: function(text) {
		this.insertOption(text);
		
		if (text.indexOf(' ') > -1) {
			text = '"' + text + '"';
		}
		this.hidden.value += ' ' + text;
		this.input.value = '';
	}
    
});

