/**
 * Multiple file upload.
 * For details about how multiple file uploading is implemented, check 
 * UploadedFilesInterceptor.java
 * 
 * @author icoloma
 */
loom.ui.MultiUpload = Class.create({

    /**
     * @param {Element('div')} div the div where the ul and the "add new" button will be located
     */
    initialize: function(div, options) {
		this.div = div;
		
		// the name of the generated file fields
		this.inputName = this.div.getExtendedAttribute('input-name'); 
		
		options = Object.extend({
			// the template of generated file fields
			template: '<li><input type="file" name="#{name}"/><a href="#" class="removefile">#{removeFile}</a></li>\n',
			// the template of the "add new" button
			buttonTemplate: '<a href="#" class="addfile">#{addFile}</a>'
		}, options || {});
		
		Object.extend(this, options); 
		
		// add link and ul if needed
		this.ul = this.div.down('ul') || (this.div.insert('<ul style="display: none"/>')).down('ul');
		this.div.insert(options.buttonTemplate.interpolate({ addFile: loom.messages['loom.ui.multiupload.add'] }));
		
		// listen events: file added and file removed
		this.div.down('a.addfile').observe('click', this.addFile.bindAsEventListener(this)); 
		this.ul.observe('click', this.removeFile.bindAsEventListener(this));
      
    },

    /** adds a new input file to the form when the "add new" button is clicked */
    addFile: function(event) {
        event.stop();
        this.ul.insert(this.template.interpolate({
           name: this.getNextInputFileName(),
           removeFile: loom.messages['loom.ui.multiupload.remove']
        }));
		this.ul.visible() || this.ul.show();
    },
	
    /** Removes a file */
    removeFile: function(event) {
		var a = event.findElement('a.removefile');
		if (a) { 
			event.stop();
			a.up("li").remove();
		}
		this.ul.select('li').length || this.ul.hide();
    },
    
    /** return the next input file name */
    getNextInputFileName: function() {
    	for (var i = 0; i < 100; i++) {
    	  var candidate = this.inputName + '[' + i + ']';
    	  var search1 = 'input[name="#{candidate}"]'.interpolate( { candidate: candidate });
    	  var search2 = 'input[name="loom-uploaded-#{candidate}"]'.interpolate( { candidate: candidate });
   	     
   	     if ($$([search1, search2]).length == 0) {
   	       return candidate;
   	     }
   	  }
   	  throw new Error('Could not find next field name (max iterations reached).');
    }
    
});

 
