package org.loom.addons.captcha;

import java.awt.image.BufferedImage;

import javax.ws.rs.GET;
import javax.ws.rs.Path;

import org.loom.action.AbstractAction;
import org.loom.annotation.Event;
import org.loom.annotation.Injected;
import org.loom.resolution.BufferedImageResolution;
import org.loom.resolution.Resolution;
import org.loom.servlet.CacheControl;

import com.octo.captcha.service.image.ImageCaptchaService;

/**
 * Generates captcha images
 * 
 * @author Rafael Serrano
 */
public class CaptchaAction extends AbstractAction {

	@Injected
	private ImageCaptchaService captchaService;

	/** 
	 * generates a captcha image 
	 */
	@GET @Path("/")
	@Event(defaultEvent=true)
	public Resolution captcha() {
		BufferedImage image = captchaService.getImageChallengeForID(getContext().getSession().getId());
		BufferedImageResolution resolution = new BufferedImageResolution(image);
		resolution.setType("png");
		CacheControl c = new CacheControl();
		c.setCacheNever();
		resolution.setCacheControl(c);
		return resolution;
	}
	
}
