package org.loom.addons.captcha;

import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.exception.ConfigException;
import org.loom.exception.EventNotFoundException;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.Event;

/**
 * Processes {@link Captcha} annotations
 * 
 * @author icoloma
 *
 */
public class CaptchaAnnotationProcessor extends AbstractInterceptorAnnotationProcessor {

	@SuppressWarnings("unchecked")
	public void process(AnnotationMetadata metadata, ActionMapping mapping) {
		for (FilteredAnnotationContainer methodWrapper : metadata.getAnnotatedMethods(Captcha.class)) {
			try {
				Event event = mapping.getEvent(methodWrapper.getName());
				event.addInterceptor(getInterceptorFactory().newInstance(CaptchaInterceptor.class));
			} catch (EventNotFoundException e) {
				throw new ConfigException("@Captcha can only be used with Event methods", e);
			}
			
		}
	}
}
