package org.loom.addons.captcha;

import java.io.IOException;

import javax.servlet.jsp.JspException;

import org.loom.addons.servlet.names.RequestParameterNames;
import org.loom.tags.core.ImgTag;
import org.loom.tags.core.InputTextTag;
import org.loom.url.UrlBuilder;

/**
 * Captcha IMG tag
 * @author icoloma
 */
public class CaptchaTag extends ImgTag {
	
	/** do not display the captcha if the user has provided a correct value (but failed another validation), defaults true */
	private boolean skipIfOk = true;

	/** not empty to render input label, default to captcha.label */
	private String label = "captcha.label";
	
	@Override
	public void doTagImpl() throws JspException, IOException {
		addCssClass("captcha");
		String validatedID = request.getParameter(RequestParameterNames.VALIDATED_CAPTCHA_ID);
		if (skipIfOk && validatedID != null) {
			// if the provided captcha is OK but the user failed some other form validation,
			// do not display a new captcha 
			out.printHiddenField(RequestParameterNames.VALIDATED_CAPTCHA_ID, validatedID);
		} else {
			UrlBuilder url = getUrlBuilder();
			if (url.isEmpty()) {
				url.setAction(CaptchaAction.class); 
			}
			if (getTitle() == null) {
				setTitle(label);
			}
			super.doTagImpl();
			
			// print the input tag
			InputTextTag tag = new InputTextTag();
			if (label.length() == 0) {
				tag.setRenderLabel(false);
			} else {
				tag.setLabel(label);
			}
			tag.setName(RequestParameterNames.CAPTCHA);
			tag.setValue("");
			tag.setAutocomplete(false);
			tag.setCssClass("captcha required string");
			tag.setJspContext(getPageContext());
			tag.doTag();
		}
	}

	public void setSkipIfOk(boolean skipIfOk) {
		this.skipIfOk = skipIfOk;
	}

	public void setLabel(String label) {
		this.label = label;
	}

}
