/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.confirmation;

import org.loom.servlet.LoomServletRequest;

/**
 * Because of legal requirements, certain applications have to log 
 * when users accept or reject a disclaimer or confirmation request.
 * This class gets informed of each event.
 * @author icoloma
 */
public interface ConfirmationLogger {
	
	/**
	 * Log a successful confirmation process (e.g. the user accepts the disclaimer)
	 * @param request the current request object
	 * @param type the type of confirmation
	 * @param id the id used to identify the confirmation
	 */
	public void logAccepts(LoomServletRequest request, ConfirmationType type, String id);
	
	/**
	 * Log an unsuccessful confirmation process (e.g. the user rejects the disclaimer).
	 * Note that rejected confirmation can not be logged (timeouts, browser back button, etc)
	 * @param request the current request object
	 * @param type the type of confirmation
	 * @param id the id used to identify e.g. the disclaimer
	 */
	public void logRejects(LoomServletRequest request, ConfirmationType type, String id);

}
