/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.confirmation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks an event that requires confirmation to be executed.
 * The following types are supported:
 * <ul>
 * <li>CONFIRMATION: the framework asks for confirmation each and every time the event is called</li>
 * <li>DISCLAIMER: the framework asks for confirmation once per id and user session.
 * </ul>
 * 
 * @author icoloma
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.METHOD})
@Documented
public @interface RequiresConfirmation {

	/**
	 * The id of this confirmation. If type is DISCLAIMER, this id is used to locate the disclaimer 
	 * in the user session and check if it has been accepted.
	 * In any case, the id is used to log confirmation events
	 */
	String id();
	
	/** 
	 * The message to show to the user. Defaults to the same value as id.
	 * Note that this attribute could be used to show the same message for several disclaimers, 
	 * for example. 
	 */
	String message() default "";
	
	/** The type of confirmation, default CONFIRMATION */
	ConfirmationType type() default ConfirmationType.CONFIRMATION;
	
}
